/*
 * Decompiled with CFR 0.152.
 */
package hermes.providers.messages;

import hermes.providers.messages.MessageImpl;
import java.nio.ByteBuffer;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage {
    private static final int defaultSize = 65536;
    private ByteBuffer bytes;
    private int maxPosition = 0;
    private int position = 0;

    public BytesMessageImpl(byte[] someBytes) {
        this.bytes = ByteBuffer.wrap(someBytes);
    }

    public BytesMessageImpl() {
        this.bytes = ByteBuffer.allocate(65536);
    }

    public BytesMessageImpl(int size) {
        this.bytes = ByteBuffer.allocate(size);
    }

    public long getBodyLength() throws JMSException {
        return this.bytes.capacity();
    }

    public boolean readBoolean() throws JMSException {
        return false;
    }

    public byte readByte() throws JMSException {
        try {
            return this.bytes.get(this.position++);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new MessageEOFException("EOF");
        }
    }

    public int readUnsignedByte() throws JMSException {
        return 0;
    }

    public short readShort() throws JMSException {
        return 0;
    }

    public int readUnsignedShort() throws JMSException {
        return 0;
    }

    public char readChar() throws JMSException {
        return '\u0000';
    }

    public int readInt() throws JMSException {
        return 0;
    }

    public long readLong() throws JMSException {
        return 0L;
    }

    public float readFloat() throws JMSException {
        return 0.0f;
    }

    public double readDouble() throws JMSException {
        return 0.0;
    }

    public String readUTF() throws JMSException {
        return null;
    }

    public int readBytes(byte[] arg0) throws JMSException {
        try {
            if (this.bytes.capacity() < this.position + arg0.length) {
                this.bytes.get(arg0, this.position, this.bytes.capacity());
                int n = this.bytes.capacity() - this.position;
                return n;
            }
            this.bytes.get(arg0, this.position, this.position + arg0.length);
            int n = arg0.length;
            return n;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new MessageEOFException("EOF");
        }
        finally {
            this.position += arg0.length;
        }
    }

    public int readBytes(byte[] arg0, int arg1) throws JMSException {
        try {
            if (this.bytes.capacity() < this.position + arg1) {
                arg1 = this.bytes.capacity() - this.position;
            }
            this.bytes.get(arg0, this.position, this.position + arg1);
            int n = arg1;
            return n;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new MessageEOFException("EOF");
        }
        finally {
            this.position += arg1;
        }
    }

    public void writeBoolean(boolean arg0) throws JMSException {
    }

    public void writeByte(byte arg0) throws JMSException {
    }

    public void writeShort(short arg0) throws JMSException {
    }

    public void writeChar(char arg0) throws JMSException {
    }

    public void writeInt(int arg0) throws JMSException {
    }

    public void writeLong(long arg0) throws JMSException {
    }

    public void writeFloat(float arg0) throws JMSException {
    }

    public void writeDouble(double arg0) throws JMSException {
    }

    public void writeUTF(String arg0) throws JMSException {
    }

    public void writeBytes(byte[] arg0) throws JMSException {
    }

    public void writeBytes(byte[] arg0, int arg1, int arg2) throws JMSException {
    }

    public void writeObject(Object arg0) throws JMSException {
    }

    public void reset() throws JMSException {
        this.position = 0;
        this.bytes.rewind();
    }

    public String toString() {
        return new String(this.bytes.array());
    }
}

