/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueEnumeration;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.browser.MessageRenderer;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.mq.MQSeriesMessageRenderer;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.log4j.Logger;

public class MQSeriesAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(MQSeriesAdmin.class);
    private static Field baseMessageField;
    private MQQueueManager queueManager;
    private MQConnectionFactory mqCF;
    private MQSeriesMessageRenderer messageRenderer = new MQSeriesMessageRenderer(this);
    private WeakHashMap jmsToNativeMap = new WeakHashMap();

    public MQSeriesAdmin(Hermes hermes, MQConnectionFactory mqCF) {
        super(hermes);
        this.mqCF = mqCF;
    }

    private synchronized MQQueueManager getQueueManager() throws MQException {
        if (this.queueManager == null) {
            MQEnvironment.channel = this.mqCF.getChannel();
            MQEnvironment.port = this.mqCF.getPort();
            MQEnvironment.hostname = this.mqCF.getHostName();
            MQEnvironment.properties.put("transport", "MQSeries");
            this.queueManager = new MQQueueManager(this.mqCF.getQueueManager());
        }
        return this.queueManager;
    }

    @Override
    public Enumeration createBrowserProxy(Enumeration iter) throws JMSException {
        return iter;
    }

    MQMessage getMQMessage(Message m) throws JMSException {
        WeakHashMap weakHashMap = this.jmsToNativeMap;
        synchronized (weakHashMap) {
            if (this.jmsToNativeMap.containsKey(m)) {
                WeakReference ref = (WeakReference)this.jmsToNativeMap.get(m);
                return (MQMessage)ref.get();
            }
            throw new JMSException("No reference found to native message");
        }
    }

    @Override
    public String getRealDestinationName(DestinationConfig dConfig) throws JMSException {
        String queueName = super.getRealDestinationName(dConfig);
        if (queueName.startsWith("queue:///")) {
            queueName = queueName.substring(9);
        }
        if (queueName.indexOf("?") != -1) {
            queueName = queueName.substring(0, queueName.indexOf("?"));
        }
        log.debug((Object)("real name=" + queueName));
        return queueName;
    }

    @Override
    public int getDepth(DestinationConfig dConfig) throws JMSException {
        try {
            String queueName = this.getRealDestinationName(dConfig);
            MQQueue queue = this.getQueueManager().accessQueue(queueName, 33, null, null, null);
            int depth = queue.getCurrentDepth();
            queue.close();
            return depth;
        }
        catch (MQException e) {
            this.close();
            throw new HermesException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws JMSException {
        block5: {
            try {
                if (this.queueManager == null) break block5;
                try {
                    this.queueManager.disconnect();
                    this.queueManager.close();
                }
                finally {
                    this.queueManager = null;
                }
            }
            catch (MQException e) {
                throw new HermesException((Exception)((Object)e));
            }
        }
    }

    private void getQueueByType(PCFMessageAgent agent, int type, Collection destinations) throws PCFException, MQException, IOException {
        PCFMessage request = new PCFMessage(18);
        request.addParameter(2016, "*");
        request.addParameter(20, type);
        PCFMessage[] responses = agent.send(request);
        String[] names = (String[])responses[0].getParameterValue(3011);
        for (int i = 0; i < names.length; ++i) {
            DestinationConfig dConfig = new DestinationConfig();
            dConfig.setName(names[i].trim());
            dConfig.setDomain(Domain.QUEUE.getId());
            destinations.add(dConfig);
        }
    }

    @Override
    public synchronized Collection discoverDestinationConfigs() throws JMSException {
        ArrayList rval = new ArrayList();
        PCFMessageAgent agent = null;
        try {
            agent = new PCFMessageAgent(this.getQueueManager());
            this.getQueueByType(agent, 1, rval);
            this.getQueueByType(agent, 3, rval);
        }
        catch (MQException ex) {
            if (ex.reasonCode != 2033) {
                throw new HermesException((Exception)((Object)ex));
            }
            log.debug((Object)"PCF calls gave a 2033 reason code, ignoring");
        }
        catch (IOException ex) {
            throw new HermesException(ex);
        }
        finally {
            if (agent != null) {
                try {
                    agent.disconnect();
                }
                catch (MQException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map getStatistics(DestinationConfig dConfig) throws JMSException {
        LinkedHashMap<String, Object> stats = new LinkedHashMap<String, Object>();
        MQQueue queue = null;
        try {
            String queueName = this.getRealDestinationName(dConfig);
            queue = this.getQueueManager().accessQueue(queueName, 33, null, null, null);
            stats.put("Description", queue.getDescription().trim());
            stats.put("CurrentDepth", new Integer(queue.getCurrentDepth()));
            stats.put("OpenOutputCount", new Integer(queue.getOpenOutputCount()));
            stats.put("OpenInputCount", new Integer(queue.getOpenInputCount()));
            if (queue.getInhibitGet() == 1) {
                stats.put("InhibitGet", Boolean.TRUE);
            } else {
                stats.put("InhibitGet", Boolean.FALSE);
            }
            if (queue.getInhibitPut() == 1) {
                stats.put("InhibitPut", Boolean.TRUE);
            } else {
                stats.put("InhibitPut", Boolean.FALSE);
            }
            if (queue.getShareability() == 1) {
                stats.put("Sharable", Boolean.TRUE);
            } else {
                stats.put("Sharable", Boolean.FALSE);
            }
            if (queue.getTriggerControl() == 1) {
                stats.put("TriggerControl", Boolean.TRUE);
                stats.put("TriggerData", queue.getTriggerData());
                stats.put("TriggerDepth", new Integer(queue.getTriggerDepth()));
                stats.put("TriggerMessagePriority", new Integer(queue.getTriggerMessagePriority()));
                switch (queue.getTriggerType()) {
                    case 0: {
                        stats.put("TriggerType", "None");
                        break;
                    }
                    case 3: {
                        stats.put("TriggerType", "Depth");
                        break;
                    }
                    case 2: {
                        stats.put("TriggerType", "Every");
                        break;
                    }
                    case 1: {
                        stats.put("TriggerType", "First");
                        break;
                    }
                    default: {
                        stats.put("TriggerType", "Unknown");
                        break;
                    }
                }
            } else {
                stats.put("TriggerControl", Boolean.FALSE);
            }
            stats.put("MaximumDepth", new Integer(queue.getMaximumDepth()));
            stats.put("MaximumMessageLength", new Integer(queue.getMaximumMessageLength()));
        }
        catch (MQException ex) {
            if (ex.reasonCode != 2033) {
                throw new HermesException((Exception)((Object)ex));
            }
            log.debug((Object)"PCF calls gave a 2033 reason code, ignoring");
        }
        finally {
            if (queue != null) {
                try {
                    queue.close();
                }
                catch (MQException ex) {
                    log.error((Object)("ignoring error closing queue: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        return stats;
    }

    @Override
    public MessageRenderer getMessageRenderer() throws JMSException {
        return null;
    }

    static {
        try {
            baseMessageField = MQQueueEnumeration.class.getDeclaredField("baseMessage");
            baseMessageField.setAccessible(true);
        }
        catch (Throwable t) {
            log.error((Object)"cannot location baseMessage field in MQEnumeration, access to native messags unavailable");
        }
    }
}

