/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.ems;

import com.tibco.tibjms.TibjmsConnectionFactory;
import com.tibco.tibjms.admin.TibjmsAdmin;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.HermesRuntimeException;
import hermes.JNDIConnectionFactory;
import hermes.ext.ems.TibcoEMSAdmin;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class TibcoEMSAdminFactory
implements HermesAdminFactory {
    private static final Logger log = Logger.getLogger(TibcoEMSAdminFactory.class);
    private String serverURL;
    private String username;
    private String password;

    @Override
    public HermesAdmin createSession(Hermes hermes, ConnectionFactory connectionFactory) throws JMSException, NamingException {
        Object admin = null;
        return new TibcoEMSAdmin(hermes, this);
    }

    TibjmsAdmin createAdmin(ConnectionFactory connectionFactory) throws JMSException {
        TibjmsAdmin admin = null;
        try {
            if (connectionFactory instanceof JNDIConnectionFactory) {
                JNDIConnectionFactory jndiCF = (JNDIConnectionFactory)connectionFactory;
                if (this.username == null && jndiCF.getSecurityPrincipal() != null) {
                    this.username = jndiCF.getSecurityCredentials();
                    if (this.password == null && jndiCF.getSecurityCredentials() != null) {
                        this.password = jndiCF.getSecurityCredentials();
                    }
                }
                admin = new TibjmsAdmin(this.serverURL == null ? jndiCF.getProviderURL() : this.serverURL, this.username, this.password);
            } else if (connectionFactory instanceof TibjmsConnectionFactory) {
                TibjmsConnectionFactory tibCF = (TibjmsConnectionFactory)connectionFactory;
                Map ssl = this.getSSLParameters(tibCF);
                this.serverURL = this.serverURL == null ? BeanUtils.getProperty((Object)tibCF, (String)"serverUrl") : this.serverURL;
                this.username = this.username == null ? BeanUtils.getProperty((Object)tibCF, (String)"userName") : this.username;
                this.password = this.password == null ? BeanUtils.getProperty((Object)tibCF, (String)"userPassword") : this.password;
                admin = ssl.size() == 0 ? new TibjmsAdmin(this.serverURL, this.username, this.password) : new TibjmsAdmin(this.serverURL, this.username, this.password, ssl);
            }
            if (admin == null) {
                throw new HermesException("Provider is not TibcoEMS");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesException(e);
        }
        return admin;
    }

    private Map getSSLParameters(TibjmsConnectionFactory tibCF) {
        try {
            HashMap<String, String> rval = new HashMap<String, String>();
            if (BeanUtils.getProperty((Object)tibCF, (String)"SSLIdentity") != null) {
                rval.put("com.tibco.tibjms.ssl.identity", BeanUtils.getProperty((Object)tibCF, (String)"SSLIdentity"));
                rval.put("com.tibco.tibjms.ssl.auth_only", BeanUtils.getProperty((Object)tibCF, (String)"SSLAuthOnly"));
                rval.put("com.tibco.tibjms.ssl.cipher_suites", BeanUtils.getProperty((Object)tibCF, (String)"SSLCipherSuites"));
                rval.put("com.tibco.tibjms.ssl.debug_trace", BeanUtils.getProperty((Object)tibCF, (String)"SSLDebugTrace"));
                rval.put("com.tibco.tibjms.ssl.enable_verify_host", BeanUtils.getProperty((Object)tibCF, (String)"SSLEnableVerifyHost"));
                rval.put("com.tibco.tibjms.ssl.enable_verify_hostname", BeanUtils.getProperty((Object)tibCF, (String)"SSLEnableVerifyHostName"));
                rval.put("com.tibco.tibjms.ssl.expected_hostname", BeanUtils.getProperty((Object)tibCF, (String)"SSLExpectedHostName"));
                rval.put("com.tibco.tibjms.ssl.identity_encoding", BeanUtils.getProperty((Object)tibCF, (String)"SSLIdentityEncoding"));
                rval.put("com.tibco.tibjms.ssl.issuer_certs", BeanUtils.getProperty((Object)tibCF, (String)"SSLIssuerCertificate"));
                rval.put("com.tibco.tibjms.ssl.password", BeanUtils.getProperty((Object)tibCF, (String)"SSLPassword"));
                rval.put("com.tibco.tibjms.ssl.private_key", BeanUtils.getProperty((Object)tibCF, (String)"SSLPrivateKey"));
                rval.put("com.tibco.tibjms.ssl.private_key_encoding", BeanUtils.getProperty((Object)tibCF, (String)"SSLPrivateKeyEncoding"));
                rval.put("com.tibco.tibjms.ssl.trace", BeanUtils.getProperty((Object)tibCF, (String)"SSLTrace"));
                rval.put("com.tibco.tibjms.ssl.trusted_certs", BeanUtils.getProperty((Object)tibCF, (String)"SSLTrustedCertificate"));
                rval.put("com.tibco.tibjms.ssl.vendor", BeanUtils.getProperty((Object)tibCF, (String)"SSLVendor"));
            }
            return rval;
        }
        catch (Exception ex) {
            throw new HermesRuntimeException(ex);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.equals("") ? null : password;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL.equals("") ? null : serverURL;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username.equals("") ? null : username;
    }
}

