/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.BrowserTreeModel;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.browser.tasks.TaskSupport;
import hermes.config.DestinationConfig;
import hermes.swing.SwingRunner;
import java.awt.Component;
import java.util.Collection;
import javax.jms.JMSException;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DiscoverDestinationsTask
extends TaskSupport {
    private static final Logger log = Logger.getLogger(DiscoverDestinationsTask.class);
    private Hermes hermes;
    private HermesTreeNode hermesNode;
    private BrowserTreeModel treeModel;
    private String title;

    public DiscoverDestinationsTask(BrowserTreeModel treeModel, HermesTreeNode hermesNode) throws JMSException {
        super(IconCache.getIcon("jms.unknown"));
        this.hermesNode = hermesNode;
        this.treeModel = treeModel;
        this.hermes = hermesNode.getHermes();
        this.title = "Discover from " + hermesNode.getHermes().getId();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws Exception {
        try {
            final Collection destinations = this.hermes.discoverDestinationConfigs();
            for (DestinationConfig dConfig : destinations) {
                log.info((Object)("found name=" + dConfig.getName() + ", domain=" + Domain.getDomain(dConfig.getDomain()) + (dConfig.isDurable() ? " durableName=" + dConfig.getClientID() : "")));
            }
            if (this.isRunning()) {
                final StringBuffer msg = new StringBuffer();
                switch (destinations.size()) {
                    case 0: {
                        msg.append("No destinations found.");
                        break;
                    }
                    case 1: {
                        msg.append("One destination found.");
                        break;
                    }
                    default: {
                        msg.append("Discovered " + Integer.toString(destinations.size())).append(" destinations.");
                    }
                }
                if (destinations.size() == 0) {
                    SwingRunner.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), msg.toString(), "Discover.", 0);
                        }
                    });
                } else {
                    msg.append("\nWould you like to replace the current set of destinations for ").append(this.hermes.getId()).append(".");
                    SwingRunner.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (DiscoverDestinationsTask.this.hermesNode.getChildCount() == 0 || JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), msg.toString(), "Discover.", 0) == 0) {
                                try {
                                    HermesBrowser.getBrowser().replaceDestinationConfigs(DiscoverDestinationsTask.this.hermes, destinations);
                                    HermesBrowser.getBrowser().saveConfig();
                                    DiscoverDestinationsTask.this.treeModel.nodeStructureChanged(DiscoverDestinationsTask.this.hermesNode);
                                    HermesBrowser.getBrowser().getBrowserTree().expandPath(new TreePath(DiscoverDestinationsTask.this.hermesNode.getPath()));
                                    Hermes.ui.getDefaultMessageSink().add("Destinations updated for " + DiscoverDestinationsTask.this.hermes.getId());
                                }
                                catch (Exception ex) {
                                    HermesBrowser.getBrowser().showErrorDialog("Adding destinations to tree", ex);
                                }
                            } else {
                                Hermes.ui.getDefaultMessageSink().add("Update of destinations for " + DiscoverDestinationsTask.this.hermes.getId() + " cancelled.");
                            }
                        }
                    });
                }
            } else {
                Hermes.ui.getDefaultMessageSink().add("Discover on " + this.hermes.getId() + " cancelled");
            }
        }
        finally {
            this.hermes.close();
        }
    }
}

