/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.BrowseInterruptedException;
import hermes.Hermes;
import hermes.MessageSelector;
import hermes.MessageSelectorFactory;
import hermes.MessageSelectorFactoryFactory;
import hermes.browser.IconCache;
import hermes.browser.tasks.TaskSupport;
import hermes.store.MessageStore;
import hermes.util.JMSUtils;
import hermes.util.TextUtils;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import org.apache.log4j.Logger;

public class BrowseMessageStoreTask
extends TaskSupport {
    private static final Logger log = Logger.getLogger(BrowseMessageStoreTask.class);
    private MessageSelectorFactory messageSelectorFactory;
    private Hermes hermes;
    private MessageStore messageStore;
    private Destination destination;
    private MessageSelector messageSelector;

    public BrowseMessageStoreTask(Hermes hermes, MessageStore messageStore, Destination destination, String selector) throws JMSException {
        super(IconCache.getIcon("hermes.store"));
        this.hermes = hermes;
        this.messageStore = messageStore;
        this.destination = destination;
        if (selector != null) {
            MessageSelectorFactory messageSelectorFactory = MessageSelectorFactoryFactory.create();
            this.messageSelector = messageSelectorFactory.create(selector);
        }
    }

    @Override
    public String getTitle() {
        return "Browsing " + (this.destination == null ? "" : JMSUtils.getDestinationName(this.destination) + " in ") + this.messageStore.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws Exception {
        int nmessages = 0;
        QueueBrowser browser = null;
        try {
            browser = this.destination == null ? (this.hermes == null ? this.messageStore.visit() : this.messageStore.visit(this.hermes, MessageStore.HeaderPolicy.MESSAGEID_AND_DESTINATION)) : (this.hermes == null ? this.messageStore.visit(this.destination) : this.messageStore.visit(this.hermes, this.destination, MessageStore.HeaderPolicy.MESSAGEID_AND_DESTINATION));
            Enumeration iter = browser.getEnumeration();
            while (iter.hasMoreElements() && this.isRunning()) {
                Message m = (Message)iter.nextElement();
                if (m == null || this.messageSelector != null && !this.messageSelector.matches(m)) continue;
                ++nmessages;
                this.notifyMessage(m);
            }
        }
        catch (BrowseInterruptedException ex) {
            log.error((Object)("browse stopped: " + ex.getMessage()));
        }
        finally {
            log.debug((Object)("nmessages=" + nmessages));
            JMSUtils.closeQuietly(browser);
        }
        this.notifyStatus("Read " + nmessages + " message" + TextUtils.plural(nmessages) + " from " + this.messageStore.getId());
        if (this.hermes != null) {
            this.hermes.close();
        }
    }
}

