/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model.tree;

import hermes.Hermes;
import hermes.JNDIConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.BrowserTreeModel;
import hermes.browser.model.TreeUtils;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.impl.DestinationConfigKeyWrapper;
import hermes.impl.DestinationConfigKeyWrapperComparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.JMSException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class HermesTreeNode
extends AbstractTreeNode {
    private static final Logger log = Logger.getLogger(HermesTreeNode.class);
    private BrowserTreeModel model;
    private boolean cascadeNamespace = false;

    public HermesTreeNode(String id, Hermes hermes, BrowserTreeModel model) throws JMSException {
        super(id, hermes);
        this.model = model;
        this.setIcon(IconCache.getIcon("jms.connectionOpen"));
    }

    public boolean isCascadeNamespace() {
        return this.cascadeNamespace;
    }

    private void getDestinationTreeNodes(TreeNode root, HashMap<DestinationConfigKeyWrapper, DestinationConfigTreeNode> map) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode node = root.getChildAt(i);
            if (node instanceof DestinationConfigTreeNode) {
                DestinationConfigTreeNode dNode = (DestinationConfigTreeNode)node;
                map.put(new DestinationConfigKeyWrapper(this.getHermes(), dNode.getConfig()), dNode);
                continue;
            }
            this.getDestinationTreeNodes(node, map);
        }
    }

    public void setCascadeNamespace(boolean cascadeNamespace) {
        this.cascadeNamespace = cascadeNamespace;
        HashMap<DestinationConfigKeyWrapper, DestinationConfigTreeNode> map = new HashMap<DestinationConfigKeyWrapper, DestinationConfigTreeNode>();
        this.getDestinationTreeNodes(this, map);
        this.removeAllChildren();
        this.model.nodeStructureChanged(this);
        for (Map.Entry<DestinationConfigKeyWrapper, DestinationConfigTreeNode> entry : map.entrySet()) {
            DestinationConfigTreeNode destinationNode = entry.getValue();
            if (this.isCascadeNamespace()) {
                try {
                    if (this.getHermes().getConnectionFactory() instanceof JNDIConnectionFactory) {
                        TreeUtils.add(this.model, entry.getValue().getHermesTreeNode().getHermes(), entry.getValue().getDestinationName(), "/", this, new DestinationConfigTreeNode(this, destinationNode.getConfig(), true));
                        continue;
                    }
                    TreeUtils.add(this.model, entry.getValue().getHermesTreeNode().getHermes(), entry.getValue().getDestinationName(), ".", this, new DestinationConfigTreeNode(this, destinationNode.getConfig(), true));
                }
                catch (JMSException ex) {
                    HermesBrowser.getBrowser().showErrorDialog(ex);
                }
                continue;
            }
            this.add(new DestinationConfigTreeNode(this, destinationNode.getConfig(), false));
        }
    }

    public Hermes getHermes() {
        return (Hermes)this.getBean();
    }

    public void add(DestinationConfigTreeNode node) {
        TreeMap<DestinationConfigKeyWrapper, DestinationConfigTreeNode> map = new TreeMap<DestinationConfigKeyWrapper, DestinationConfigTreeNode>(new DestinationConfigKeyWrapperComparator());
        for (int i = 0; i < this.getChildCount(); ++i) {
            DestinationConfigTreeNode child = (DestinationConfigTreeNode)this.getChildAt(i);
            map.put(new DestinationConfigKeyWrapper(this.getHermes(), child.getConfig()), child);
        }
        map.put(new DestinationConfigKeyWrapper(this.getHermes(), node.getConfig()), node);
        this.removeAllChildren();
        for (Map.Entry entry : map.entrySet()) {
            super.add((MutableTreeNode)entry.getValue());
        }
    }

    public void setConnectionOpen(boolean connectionOpen) {
    }
}

