/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyPane;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.PropertyTableModel;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.DirectoryCellEditor;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.dialog.SelectorImpl;
import hermes.config.HermesConfig;
import hermes.config.WatchConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class GeneralConfigPanel
extends JPanel {
    private static final Logger log = Logger.getLogger(GeneralConfigPanel.class);
    private static final String AUDIT_DIRECTORY = "AuditDirectory";
    private static final String MESSAGES_DIRECTORY = "MessageDirectory";
    private static final String THREADPOOL = "ThreadPoolSize";
    private static final String MAX_CACHED_MESSAGES = "MaxCachedMessages";
    private static final String WATCH = "Watches";
    private static final String WATCH_ID = "Watch ";
    private static final String WATCH_UPDATE_FREQUENCY = "UpdateFrequency";
    private static final String WATCH_AGE_ALERT = "AlertWhenMessageOlderThan";
    private static final String WATCH_DEPTH_ALERT = "AlertWhenDepthGreaterThan";
    private static final String SHOW_AGE = "DisplayAgeOfOldestMessage";
    private static final String COPY_JMSCORRELATIONID = "CopyJMSCorrelationID";
    private static final String COPY_JMSTYPE = "CopyJMSType";
    private static final String COPY_JMSEXPIRATION = "CopyJMSExpiration";
    private static final String COPY_JMSREPLYTO = "CopyJMSReplyTo";
    private static final String COPY_JMSPRIORITY = "CopyJMSPriority";
    private static final String COPY_PROVIDER_PROPERTIES = "CopyProviderProperties";
    private static final String AUTO_REFRESH_PERIOD = "AutoRefreshBrowseTimeout";
    private static final String DISPLAY_ADMINFACTORY = "DisplayAdminFactory";
    private static final String CORRECT_DND = "UseCorrectDropSemantics";
    private static final String SELECTOR_IMPL = "MessageStoreSelector";
    private static final String CONSUMER_TIMEOUT = "ConsumerTimeoutWhenQueueBrowsing";
    private static final String QF_CACHE = "QuickFIXMessageCache";
    private static final String QF_FILTER_SESSION = "QuickFIXFilterSessionMessages";
    private static final String ENABLE_JYTHON = "EnableJython";
    private static final String SCROLL_MESSAGES_IN_BROWSE = "ScrollMessagesDuringBrowse";
    private static final String BASE64_ENCODE_MESSAGES = "Base64EncodeTextMessages";
    private static final String MESSAGE_STORE_MESSAGE_FACTORY = "MessageStoreMessageFactory";
    private static final String AUDIT_DIRECTORY_INFO = "The directory where audit files are written whenever you interact with a queue/topic.";
    private static final String MESSAGES_DIRECTORY_INFO = "The directory to hold your message repository files.";
    private static final String THREADPOOL_INFO = "The maximum size of the thread pool allowing concurrent tasks to take place.";
    private static final String MAX_CACHED_MESSAGES_INFO = "The maximum number of messages cached when you browse a queue/topic, when you've browsed more than this number the oldest messages are removed from view.";
    private static final String WATCH_INFO = "Destination watch options.";
    private static final String WATCH_AGE_ALERT_INFO = "If a message on the head of a queue/topic is more than this number of milliseconds old then alert. Set to 0 to disable.";
    private static final String WATCH_DEPTH_ALERT_INFO = "If the depth of the queue/topic is greater than this then alert. Set to 0 to disable.";
    private static final String SHOW_AGE_INFO = "Show the age rather than the put time of the oldest message.";
    private static final String WATCH_UPDATE_FREQUENCY_INFO = "Polling frequency (in milliseconds) to collect statistics.";
    private static final String COPY_JMSCORRELATIONID_INFO = "Copy JMSCorrelationID header property when drag and dropping messages.";
    private static final String COPY_JMSTYPE_INFO = "Copy JMSType header property when drag and dropping messages.";
    private static final String COPY_JMSEXPIRATION_INFO = "Copy JMSExpiration header property when drag and dropping messages.";
    private static final String COPY_JMSREPLYTO_INFO = "Copy JMSReplyTo header property when drag and dropping messages.";
    private static final String COPY_JMSPRIORITY_INFO = "Copy JMSPriority header property when drag and dropping messages.";
    private static final String COPY_PROVIDER_PROPERTIES_INFO = "Copy provider properties when duplicating messages";
    private static final String DISPLAY_ADMINFACTORY_INFO = "Display the admin factory configuration panel is the Preferences/Sessions dialog, set to false if you never use extensions to avoid screen clutter.";
    private static final String AUTO_REFRESH_PERIOD_INFO = "The number of seconds between each poll of a queue when using automatic refresh";
    private static final String CORRECT_DND_INFO = "When true, the default behavour when dropping messages on a queue is MOVE otherwise its COPY. When true you can use the control key to toggle between COPY and MOVE.";
    private static final String SELECTOR_IMPL_INFO = "The selector implementation to use with message stores";
    private static final String CONSUMER_TIMEOUT_INFO = "The timeout in milliseconds when using a consumer for browsing queues/topics to stop browsing. If 0 the default of 10s is used.";
    private static final String QF_CACHE_INFO = "Message cache for QuickFIX/J to control memory use";
    private static final String QF_FILTER_SESSION_INFO = "Filter out session level FIX messages";
    private static final String ENABLE_JYTHON_INFO = "Enable Jython";
    private static final String SCROLL_MESSAGES_IN_BROWSE_INFO = "Scroll to the newest message during a browse";
    private static final String BASE64_ENCODE_MESSAGES_INFO = "Base64 encode text messages when stored in XML or in message stores";
    private static final String MESSAGE_STORE_MESSAGE_FACTORY_INFO = "The JMS session to use when working with message stores";
    private PreferencesDialog dialog;
    private HermesConfig config;
    private PropertyTable propertyTable;
    private PropertyPane propertyPane;
    private Property auditDirectoryProperty;
    private Property messagesDirectoryProperty;
    private Property threadPoolProperty;
    private Property maxCachedMessagesProperty;
    private Property watchProperty;
    private Property copyJMSCorrelationIdProperty;
    private Property copyJMSTypeProperty;
    private Property copyJMSExpirationProperty;
    private Property copyJMSReplyToProperty;
    private Property copyJMSPriorityProperty;
    private Property copyProviderPropertiesProperty;
    private Property displayAdminFactoryProperty;
    private Property autoRefreshPeriodProperty;
    private Property correctDNDProperty;
    private Property selectorImplProperty;
    private Property consumerTimeoutProperty;
    private Property quickFIXCacheProperty;
    private Property quickFIXCacheFilterSessionProperty;
    private Property enableJythonProperty;
    private Property scrollMessagesInBrowseProperty;
    private Property base64EncodeMessagesProperty;
    private Property messageStoreMessageFactory;
    private List<Runnable> watchSetters = new ArrayList<Runnable>();

    public GeneralConfigPanel(PreferencesDialog dialog) {
        this.dialog = dialog;
        this.init();
    }

    private void init() {
        Border border = BorderFactory.createBevelBorder(0);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(border, "General Options"));
    }

    public void updateModel() {
        this.config.setCopyJMSCorrelationID((boolean)((Boolean)this.copyJMSCorrelationIdProperty.getValue()));
        this.config.setCopyJMSType((boolean)((Boolean)this.copyJMSTypeProperty.getValue()));
        this.config.setCopyJMSExpiration((boolean)((Boolean)this.copyJMSExpirationProperty.getValue()));
        this.config.setCopyJMSReplyTo((boolean)((Boolean)this.copyJMSReplyToProperty.getValue()));
        this.config.setCopyJMSPriority((boolean)((Boolean)this.copyJMSPriorityProperty.getValue()));
        this.config.setCopyJMSProviderProperties((boolean)((Boolean)this.copyProviderPropertiesProperty.getValue()));
        this.config.setDisplayFactoryAdmin((boolean)((Boolean)this.displayAdminFactoryProperty.getValue()));
        this.config.setAutoBrowseRefreshRate((Integer)this.autoRefreshPeriodProperty.getValue());
        this.config.setCorrectDropSemantics((Boolean)this.correctDNDProperty.getValue());
        this.config.setSelectorImpl(((SelectorImpl)this.selectorImplProperty.getValue()).getClazz().getName());
        this.config.getQuickFIX().setCacheSize((int)((Integer)this.quickFIXCacheProperty.getValue()));
        this.config.getQuickFIX().setFilterSessionMsgTypes((Boolean)this.quickFIXCacheFilterSessionProperty.getValue());
        this.config.setEnableJython((Boolean)this.enableJythonProperty.getValue());
        this.config.setScrollMessagesDuringBrowse((Boolean)this.scrollMessagesInBrowseProperty.getValue());
        this.config.setBase64EncodeMessages((Boolean)this.base64EncodeMessagesProperty.getValue());
        this.config.setMessageStoreMessageFactory((String)this.messageStoreMessageFactory.getValue());
        if (this.consumerTimeoutProperty.getValue() != null) {
            this.config.setQueueBrowseConsumerTimeout((Long)this.consumerTimeoutProperty.getValue());
        }
        if (this.threadPoolProperty.getValue() != null) {
            this.config.setMaxThreadPoolSize((int)((Integer)this.threadPoolProperty.getValue()));
        }
        if (this.auditDirectoryProperty.getValue() != null) {
            this.config.setAuditDirectory(((File)this.auditDirectoryProperty.getValue()).getAbsolutePath());
        }
        if (this.messagesDirectoryProperty.getValue() != null) {
            this.config.setMessageFilesDir(((File)this.messagesDirectoryProperty.getValue()).getAbsolutePath());
        }
        if (this.maxCachedMessagesProperty.getValue() != null) {
            this.config.setMaxMessagesInBrowserPane((int)((Integer)this.maxCachedMessagesProperty.getValue()));
        }
        HermesBrowser.getBrowser().getMessageRepository().setDirectory(this.config.getMessageFilesDir());
        for (Runnable r : this.watchSetters) {
            r.run();
        }
    }

    public void setHermesConfig(HermesConfig config) {
        this.config = config;
        ArrayList<Property> list = new ArrayList<Property>();
        this.watchSetters.clear();
        this.auditDirectoryProperty = new PropertyImpl(AUDIT_DIRECTORY, new File(config.getAuditDirectory() != null ? config.getAuditDirectory() : ""), AUDIT_DIRECTORY_INFO, File.class);
        this.messagesDirectoryProperty = new PropertyImpl(MESSAGES_DIRECTORY, new File(config.getMessageFilesDir() != null ? config.getMessageFilesDir() : ""), MESSAGES_DIRECTORY_INFO, File.class);
        this.threadPoolProperty = new PropertyImpl(THREADPOOL, new Integer(config.getMaxThreadPoolSize()), THREADPOOL_INFO, Integer.class);
        this.maxCachedMessagesProperty = new PropertyImpl(MAX_CACHED_MESSAGES, new Integer(config.getMaxMessagesInBrowserPane()), MAX_CACHED_MESSAGES_INFO, Integer.class);
        this.copyJMSCorrelationIdProperty = new PropertyImpl(COPY_JMSCORRELATIONID, new Boolean(config.isCopyJMSCorrelationID()), COPY_JMSCORRELATIONID_INFO, Boolean.class);
        this.copyJMSTypeProperty = new PropertyImpl(COPY_JMSTYPE, new Boolean(config.isCopyJMSType()), COPY_JMSTYPE_INFO, Boolean.class);
        this.copyJMSExpirationProperty = new PropertyImpl(COPY_JMSEXPIRATION, new Boolean(config.isCopyJMSExpiration()), COPY_JMSEXPIRATION_INFO, Boolean.class);
        this.copyJMSReplyToProperty = new PropertyImpl(COPY_JMSREPLYTO, new Boolean(config.isCopyJMSReplyTo()), COPY_JMSREPLYTO_INFO, Boolean.class);
        this.copyJMSPriorityProperty = new PropertyImpl(COPY_JMSPRIORITY, new Boolean(config.isCopyJMSPriority()), COPY_JMSPRIORITY_INFO, Boolean.class);
        this.copyProviderPropertiesProperty = new PropertyImpl(COPY_PROVIDER_PROPERTIES, new Boolean(config.isCopyJMSProviderProperties()), COPY_PROVIDER_PROPERTIES_INFO, Boolean.class);
        this.displayAdminFactoryProperty = new PropertyImpl(DISPLAY_ADMINFACTORY, new Boolean(config.isDisplayFactoryAdmin()), DISPLAY_ADMINFACTORY_INFO, Boolean.class);
        this.autoRefreshPeriodProperty = new PropertyImpl(AUTO_REFRESH_PERIOD, new Integer(config.getAutoBrowseRefreshRate()), AUTO_REFRESH_PERIOD_INFO, Integer.class);
        this.correctDNDProperty = new PropertyImpl(CORRECT_DND, new Boolean(config.isCorrectDropSemantics()), CORRECT_DND_INFO, Boolean.class);
        this.selectorImplProperty = new PropertyImpl(SELECTOR_IMPL, SelectorImpl.getWithClassName(config.getSelectorImpl()), SELECTOR_IMPL_INFO, SelectorImpl.class);
        this.consumerTimeoutProperty = new PropertyImpl(CONSUMER_TIMEOUT, new Long(config.getQueueBrowseConsumerTimeout() == null ? 0L : config.getQueueBrowseConsumerTimeout()), CONSUMER_TIMEOUT_INFO, Long.class);
        this.watchProperty = new PropertyImpl(WATCH, WATCH_INFO);
        this.quickFIXCacheProperty = new PropertyImpl(QF_CACHE, new Integer(config.getQuickFIX().getCacheSize()), QF_CACHE_INFO, Integer.class);
        this.quickFIXCacheFilterSessionProperty = new PropertyImpl(QF_FILTER_SESSION, new Boolean(config.getQuickFIX().isFilterSessionMsgTypes() == null ? false : config.getQuickFIX().isFilterSessionMsgTypes()), QF_FILTER_SESSION_INFO, Boolean.class);
        this.enableJythonProperty = new PropertyImpl(ENABLE_JYTHON, new Boolean(config.isEnableJython()), ENABLE_JYTHON_INFO, Boolean.class);
        this.scrollMessagesInBrowseProperty = new PropertyImpl(SCROLL_MESSAGES_IN_BROWSE, new Boolean(config.isScrollMessagesDuringBrowse()), SCROLL_MESSAGES_IN_BROWSE_INFO, Boolean.class);
        this.base64EncodeMessagesProperty = new PropertyImpl(BASE64_ENCODE_MESSAGES, new Boolean(config.isBase64EncodeMessages()), BASE64_ENCODE_MESSAGES_INFO, Boolean.class);
        this.messageStoreMessageFactory = new PropertyImpl(MESSAGE_STORE_MESSAGE_FACTORY, config.getMessageStoreMessageFactory(), MESSAGE_STORE_MESSAGE_FACTORY_INFO, Hermes.class);
        for (final WatchConfig wConfig : config.getWatch()) {
            PropertyImpl watchIdProperty = new PropertyImpl(wConfig.getId(), "Destination watch options. for " + wConfig.getId());
            final PropertyImpl watchFrequenceProperty = new PropertyImpl(WATCH_UPDATE_FREQUENCY, new Long(wConfig.getUpdateFrequency()), WATCH_UPDATE_FREQUENCY_INFO, Long.class);
            final PropertyImpl watchAgeAlertProperty = new PropertyImpl(WATCH_AGE_ALERT, new Long(wConfig.getDefaultAgeAlertThreshold()), WATCH_AGE_ALERT_INFO, Long.class);
            final PropertyImpl watchDepthAlertProperty = new PropertyImpl(WATCH_DEPTH_ALERT, new Integer(wConfig.getDefaultDepthAlertThreshold()), WATCH_DEPTH_ALERT_INFO, Integer.class);
            final PropertyImpl showAgeProperty = new PropertyImpl(SHOW_AGE, new Boolean(wConfig.isShowAge()), SHOW_AGE_INFO, Boolean.class);
            watchIdProperty.addChild((Object)watchFrequenceProperty);
            watchIdProperty.addChild((Object)watchAgeAlertProperty);
            watchIdProperty.addChild((Object)watchDepthAlertProperty);
            watchIdProperty.addChild((Object)showAgeProperty);
            this.watchProperty.addChild((Object)watchIdProperty);
            this.watchSetters.add(new Runnable(){

                @Override
                public void run() {
                    if (showAgeProperty.getValue() != null) {
                        wConfig.setShowAge((boolean)((Boolean)showAgeProperty.getValue()));
                    }
                    if (watchAgeAlertProperty.getValue() != null) {
                        if (watchAgeAlertProperty.getValue() instanceof Long) {
                            wConfig.setDefaultAgeAlertThreshold((long)((Long)watchAgeAlertProperty.getValue()));
                        } else {
                            wConfig.setDefaultAgeAlertThreshold((long)((Long)watchAgeAlertProperty.getValue()));
                        }
                    }
                    if (watchDepthAlertProperty.getValue() != null) {
                        wConfig.setDefaultDepthAlertThreshold((int)((Integer)watchDepthAlertProperty.getValue()));
                    }
                    if (watchFrequenceProperty.getValue() != null) {
                        if (watchFrequenceProperty.getValue() instanceof Long) {
                            wConfig.setUpdateFrequency((long)((Long)watchFrequenceProperty.getValue()));
                        } else {
                            wConfig.setUpdateFrequency((long)((Long)watchFrequenceProperty.getValue()));
                        }
                    }
                    HermesBrowser.getBrowser().getWatchFrame(wConfig.getId()).updateConfig();
                }
            });
        }
        this.auditDirectoryProperty.setEditorContext(DirectoryCellEditor.CONTEXT);
        this.messagesDirectoryProperty.setEditorContext(DirectoryCellEditor.CONTEXT);
        list.add(this.auditDirectoryProperty);
        list.add(this.messagesDirectoryProperty);
        list.add(this.threadPoolProperty);
        list.add(this.maxCachedMessagesProperty);
        list.add(this.copyJMSCorrelationIdProperty);
        list.add(this.copyJMSExpirationProperty);
        list.add(this.copyJMSPriorityProperty);
        list.add(this.copyJMSReplyToProperty);
        list.add(this.copyJMSTypeProperty);
        list.add(this.copyProviderPropertiesProperty);
        list.add(this.displayAdminFactoryProperty);
        list.add(this.autoRefreshPeriodProperty);
        list.add(this.correctDNDProperty);
        list.add(this.selectorImplProperty);
        list.add(this.consumerTimeoutProperty);
        list.add(this.quickFIXCacheProperty);
        list.add(this.quickFIXCacheFilterSessionProperty);
        list.add(this.enableJythonProperty);
        list.add(this.scrollMessagesInBrowseProperty);
        list.add(this.base64EncodeMessagesProperty);
        list.add(this.messageStoreMessageFactory);
        list.add(this.watchProperty);
        PropertyTableModel model = new PropertyTableModel(list);
        this.propertyTable = new PropertyTable((TableModel)model);
        this.propertyTable.expandFirstLevel();
        if (this.propertyPane != null) {
            this.remove((Component)this.propertyPane);
        }
        this.propertyPane = new PropertyPane(this.propertyTable);
        this.add((Component)this.propertyPane, "Center");
    }

    public static class PropertyImpl
    extends Property {
        public Object value;

        public Object getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public PropertyImpl(String name, String value) {
            super(name, value);
        }

        public PropertyImpl(String name, Object value, String description, Class type) {
            super(name, description, type);
            this.value = value;
        }
    }
}

