/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyPane;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.swing.JideScrollPane;
import hermes.JNDIContextFactory;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.dialog.ClasspathIdCellEdtitor;
import hermes.config.NamingConfig;
import hermes.config.PropertySetConfig;
import hermes.impl.LoaderSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class EditNamingConfigDialog
extends StandardDialog {
    private static final Logger log = Logger.getLogger(EditNamingConfigDialog.class);
    private static Vector selectionHistory = new Vector();
    private JPanel topPanel = new JPanel();
    private List namingConfigs;
    private String selectedConfig;
    private Map namingConfigsByName = new HashMap();
    private JComboBox comboBox;
    private JideScrollPane scrollPane = new JideScrollPane();
    private JNDIContextFactory bean;
    private Property classpathIdProperty;
    private String currentSelection;
    private NamingConfig newConfig;

    public EditNamingConfigDialog(Frame parent, String selectedConfig, List namingConfigs) {
        super(parent, "JNDI InitialContext", true);
        this.namingConfigs = namingConfigs;
        this.selectedConfig = selectedConfig;
        this.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNamingConfigDialog.this.onOK();
            }
        });
    }

    public EditNamingConfigDialog(Frame parent, NamingConfig newConfig, List namingConfigs) {
        this(parent, (String)null, namingConfigs);
        this.newConfig = newConfig;
        this.selectedConfig = newConfig.getId();
        this.namingConfigsByName.put(newConfig.getId(), newConfig);
    }

    protected void onOK() {
        try {
            NamingConfig config = (NamingConfig)this.namingConfigsByName.get(this.comboBox.getSelectedItem());
            Map map = PropertyUtils.describe((Object)this.bean);
            config.setClasspathId(this.classpathIdProperty.getValue().toString());
            if (config.getProperties() == null) {
                config.setProperties(new PropertySetConfig());
            } else {
                config.getProperties().getProperty().clear();
            }
            HermesBrowser.getConfigDAO().populatePropertySet(map, config.getProperties());
            if (config == this.newConfig) {
                this.namingConfigs.add(config);
            }
            HermesBrowser.getBrowser().saveConfig();
            HermesBrowser.getBrowser().loadConfig();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            HermesBrowser.getBrowser().showErrorDialog(e);
        }
    }

    public JComponent createBannerPanel() {
        JLabel label = new JLabel(IconCache.getIcon("hermes/browser/icons/jndi_large.gif"), 4);
        return label;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.addButton((AbstractButton)okButton);
        buttonPanel.addButton((AbstractButton)cancelButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNamingConfigDialog.this.onOK();
                EditNamingConfigDialog.this.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNamingConfigDialog.this.dispose();
            }
        });
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return buttonPanel;
    }

    private ComboBoxModel createComboBoxModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (this.newConfig != null) {
            model.addElement(this.newConfig.getId());
        }
        for (NamingConfig config : this.namingConfigs) {
            this.namingConfigsByName.put(config.getId(), config);
            model.addElement(config.getId());
            if (this.selectedConfig != null) continue;
            this.selectedConfig = config.getId();
        }
        return model;
    }

    public JComponent createContentPanel() {
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.comboBox = new JComboBox(this.createComboBoxModel());
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNamingConfigDialog.this.doSelectionChanged();
            }
        });
        this.topPanel.add((Component)this.comboBox, "North");
        this.topPanel.add((Component)this.scrollPane, "Center");
        this.comboBox.setSelectedItem(this.selectedConfig);
        return this.topPanel;
    }

    public void doSelectionChanged() {
        try {
            String selectedConfig = (String)this.comboBox.getSelectedItem();
            final NamingConfig config = (NamingConfig)this.namingConfigsByName.get(selectedConfig);
            PropertySetConfig propertySet = config.getProperties();
            if (this.currentSelection == null || !this.currentSelection.equals(selectedConfig)) {
                this.currentSelection = selectedConfig;
                this.bean = new JNDIContextFactory();
                LoaderSupport.populateBean(this.bean, propertySet);
                Map properties = PropertyUtils.describe((Object)this.bean);
                ArrayList<Property> list = new ArrayList<Property>();
                this.classpathIdProperty = new Property("loader", "Classpath Loader to use.", String.class){
                    private String classpathId;
                    {
                        super(x0, x1, x2);
                        this.classpathId = config.getClasspathId();
                    }

                    public void setValue(Object value) {
                        this.classpathId = value.toString();
                    }

                    public Object getValue() {
                        return this.classpathId;
                    }

                    public boolean hasValue() {
                        return true;
                    }
                };
                this.classpathIdProperty.setEditorContext(ClasspathIdCellEdtitor.CONTEXT);
                list.add(this.classpathIdProperty);
                for (Map.Entry entry : properties.entrySet()) {
                    String propertyValue;
                    final String propertyName = (String)entry.getKey();
                    String string = propertyValue = entry.getValue() != null ? entry.getValue() : "";
                    if (propertyName.equals("class") || propertyName.equals("name")) continue;
                    Property displayProperty = new Property(propertyName, propertyName, PropertyUtils.getPropertyType((Object)this.bean, (String)propertyName)){

                        public void setValue(Object value) {
                            try {
                                PropertyUtils.setProperty((Object)EditNamingConfigDialog.this.bean, (String)propertyName, (Object)value);
                            }
                            catch (Exception e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }

                        public Object getValue() {
                            try {
                                return PropertyUtils.getProperty((Object)EditNamingConfigDialog.this.bean, (String)propertyName);
                            }
                            catch (Exception e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                                return null;
                            }
                        }

                        public boolean hasValue() {
                            return true;
                        }
                    };
                    list.add(displayProperty);
                }
                PropertyTableModel model = new PropertyTableModel(list);
                PropertyTable table = new PropertyTable((TableModel)model);
                table.setAutoResizeMode(4);
                PropertyPane pane = new PropertyPane(table);
                pane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                    }
                });
                model.expandAll();
                this.scrollPane.setViewportView((Component)pane);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            HermesBrowser.getBrowser().showErrorDialog(e);
        }
    }
}

