/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import hermes.browser.HermesBrowser;
import hermes.browser.dialog.MapPropertyPanel;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class BeanPropertyPanel
extends MapPropertyPanel {
    private static final long serialVersionUID = 4415416943574076763L;
    private static final Logger log = Logger.getLogger(BeanPropertyPanel.class);
    private List onOK = new ArrayList();
    private Object bean;
    private boolean editable = false;
    private boolean setProperty = true;

    public BeanPropertyPanel(Object bean, boolean editable, boolean setProperty) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        super(PropertyUtils.describe((Object)bean), editable);
        this.bean = bean;
        this.setProperty = setProperty;
    }

    public BeanPropertyPanel(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this(bean, false, true);
    }

    @Override
    protected JComponent createNorthComponent() {
        JLabel classNameLabel = new JLabel("Class: " + this.bean.getClass().getName());
        classNameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return classNameLabel;
    }

    @Override
    protected void onSetProperty(String propertyName, Object propertyValue) {
        try {
            if (this.setProperty) {
                PropertyUtils.setProperty((Object)this.bean, (String)propertyName, (Object)propertyValue);
            }
            super.onSetProperty(propertyName, propertyValue);
        }
        catch (Throwable e) {
            HermesBrowser.getBrowser().showErrorDialog("Cannot set property " + propertyName, e);
        }
    }
}

