/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class AbstractOptionDialog
extends JDialog {
    public static final int OPTION_OK = 1;
    public static final int OPTION_CANCEL = 2;
    public static final int OPTION_APPLY = 4;
    public static final int OPTION_OK_CANCEL = 3;
    public static final int OPTION_OK_CANCEL_APPLY = 7;
    public static final int STYLE_LEFT_ALIGN = 8;
    public static final int STYLE_RIGHT_ALIGN = 16;
    public static final int STYLE_CENTER_ALIGN = 32;
    public static final int DISPLAY_CENTER_DIALOG = 64;
    public static final int BEHAVE_DIRTY_ALWAYS = 0x40000000;
    private Dimension m_buttonDim;
    private JPanel m_optionsPane;
    private Container m_bodyPane;
    private JButton m_applyButton;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private int m_dialogProperties = 23;
    private boolean m_bIsDirty = false;
    private int m_returnCode = -1;

    public AbstractOptionDialog(Frame parent, String name, boolean modal) {
        super(parent, name, modal);
    }

    public void init() {
        this.initComponents();
        this.setDialogProperties(this.m_dialogProperties, false);
        this.setButtonDimension(new Dimension(73, 27), false);
    }

    public int doModal() {
        this.m_returnCode = -1;
        boolean tmpVar = this.isModal();
        this.setModal(true);
        this.show();
        this.setModal(tmpVar);
        return this.m_returnCode;
    }

    public void centerDialog() {
        Window owner = this.getOwner();
        Dimension dim = owner == null || !owner.isVisible() ? this.getToolkit().getScreenSize() : owner.getSize();
        this.setLocation((dim.width - this.getWidth()) / 2, (dim.height - this.getHeight()) / 2);
    }

    public Dimension getButtonDimension() {
        return this.m_buttonDim;
    }

    public void setButtonDimension(Dimension dim) {
        this.setButtonDimension(dim, true);
    }

    public void setButtonDimension(Dimension dim, boolean shouldPack) {
        this.m_buttonDim = dim;
        this.m_okButton.setPreferredSize(this.m_buttonDim);
        this.m_applyButton.setPreferredSize(this.m_buttonDim);
        this.m_cancelButton.setPreferredSize(this.m_buttonDim);
        if (shouldPack) {
            this.pack();
        }
    }

    public int getDialogStyle() {
        return this.m_dialogProperties;
    }

    public void setDialogProperties(int flags) {
        this.setDialogProperties(flags, true);
    }

    public void setDialogProperties(int flags, boolean shouldPack) {
        this.m_dialogProperties = 0;
        if ((flags & 0x10) > 0 || (flags & 0x28) == 0) {
            this.m_optionsPane.setLayout(new FlowLayout(2));
            this.m_dialogProperties |= 0x10;
        } else if ((flags & 8) > 0) {
            this.m_optionsPane.setLayout(new FlowLayout(0));
            this.m_dialogProperties |= 8;
        } else {
            this.m_optionsPane.setLayout(new FlowLayout(1));
            this.m_dialogProperties |= 0x20;
        }
        if ((flags & 1) > 0 || (flags & 7) == 0) {
            this.m_okButton.setVisible(true);
            this.m_dialogProperties |= 1;
        } else {
            this.m_okButton.setVisible(false);
        }
        if ((flags & 2) > 0 || (flags & 7) == 0) {
            this.m_cancelButton.setVisible(true);
            this.m_dialogProperties |= 2;
        } else {
            this.m_cancelButton.setVisible(false);
        }
        if ((flags & 4) > 0 || (flags & 7) == 0) {
            this.m_applyButton.setVisible(true);
            this.m_dialogProperties |= 4;
        } else {
            this.m_applyButton.setVisible(false);
        }
        if ((flags & 0x40000000) > 0) {
            this.m_applyButton.setEnabled(true);
            this.m_dialogProperties |= 0x40000000;
        } else if (this.m_bIsDirty) {
            this.m_applyButton.setEnabled(true);
        } else {
            this.m_applyButton.setEnabled(false);
        }
        if ((flags & 0x40) > 0) {
            this.centerDialog();
        }
        if (shouldPack) {
            this.pack();
        }
    }

    protected abstract Container initBodyPane();

    protected abstract void updateData(boolean var1);

    protected void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.initBodyPane(), "Center");
        this.getContentPane().add((Component)this.initOptionsPane(), "South");
    }

    protected Container initOptionsPane() {
        this.m_optionsPane = new JPanel();
        this.m_okButton = new JButton();
        this.m_okButton.setText("OK");
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractOptionDialog.this.m_returnCode = 1;
                AbstractOptionDialog.this.onOK(evt);
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent evt) {
            }

            @Override
            public void componentResized(ComponentEvent evt) {
            }

            @Override
            public void componentMoved(ComponentEvent evt) {
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                AbstractOptionDialog.this.getRootPane().setDefaultButton(AbstractOptionDialog.this.m_okButton);
            }
        });
        this.m_optionsPane.add(this.m_okButton);
        this.m_cancelButton = new JButton();
        this.m_cancelButton.setText("Cancel");
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractOptionDialog.this.m_returnCode = 2;
                AbstractOptionDialog.this.onCancel(evt);
            }
        });
        this.m_optionsPane.add(this.m_cancelButton);
        this.m_applyButton = new JButton();
        this.m_applyButton.setText("Apply");
        this.m_applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractOptionDialog.this.m_returnCode = 4;
                AbstractOptionDialog.this.onApply(evt);
            }
        });
        this.m_optionsPane.add(this.m_applyButton);
        return this.m_optionsPane;
    }

    protected void fireWindowClosing() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public void setDirty() {
        this.m_bIsDirty = true;
        if (!this.isDirtyAlways() && this.m_applyButton != null) {
            this.m_applyButton.setEnabled(true);
        }
    }

    protected void onOK(ActionEvent evt) {
        if (this.isDirtyAlways() || this.m_bIsDirty) {
            this.updateData(true);
        }
        this.fireWindowClosing();
    }

    protected void onApply(ActionEvent evt) {
        this.updateData(true);
        this.m_bIsDirty = false;
        if (!this.isDirtyAlways()) {
            this.m_applyButton.setEnabled(false);
        }
    }

    protected void onCancel(ActionEvent evt) {
        this.fireWindowClosing();
    }

    protected Container getBodyPane() {
        return this.m_bodyPane;
    }

    protected JPanel getOptionsPane() {
        return this.m_optionsPane;
    }

    private boolean isDirtyAlways() {
        return (this.m_dialogProperties & 0x40000000) > 0;
    }
}

