/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.JidePopupMenu;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.components.BrowserTree;
import hermes.browser.components.ContextTree;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.MessageStoreDestinationTreeNode;
import hermes.browser.model.tree.MessageStoreTreeNode;
import hermes.browser.model.tree.QueueTopicTreeNode;
import hermes.browser.model.tree.QueueTreeNode;
import hermes.browser.model.tree.TopicTreeNode;
import hermes.browser.tasks.RecordDestinationTask;
import hermes.browser.tasks.ReplayMessagesFromStoreTask;
import hermes.browser.tasks.ThreadPool;
import hermes.browser.transferable.HermesConfigGroup;
import hermes.browser.transferable.JMSAdministeredObjectTransferable;
import hermes.config.DestinationConfig;
import hermes.config.WatchConfig;
import hermes.fix.FIXMessageTable;
import hermes.store.MessageStore;
import hermes.swing.actions.ActionRegistry;
import hermes.swing.actions.AddDurableTopicAction;
import hermes.swing.actions.AddQueueAction;
import hermes.swing.actions.AddToExistingWatchAction;
import hermes.swing.actions.AddTopicAction;
import hermes.swing.actions.BrowseDestinationOrContextAction;
import hermes.swing.actions.BrowseDestinationWithSelectorAction;
import hermes.swing.actions.CascadeBrowserTreeAction;
import hermes.swing.actions.ChainByClOrdIDAction;
import hermes.swing.actions.CollapseBrowserTreeAction;
import hermes.swing.actions.CopyBrowserNodeAction;
import hermes.swing.actions.CopyMessagesToClipboardAction;
import hermes.swing.actions.CreateNewContextAction;
import hermes.swing.actions.CreateNewJNDIContextAction;
import hermes.swing.actions.CreateNewMessageStoreAction;
import hermes.swing.actions.CreateNewSessionAction;
import hermes.swing.actions.CreateNewSessionFromJNDIAction;
import hermes.swing.actions.CreateNewWatchAction;
import hermes.swing.actions.CutMessagesToClipboardAction;
import hermes.swing.actions.DeleteBrowserTreeNodeAction;
import hermes.swing.actions.DeleteMessagesAction;
import hermes.swing.actions.DiscoverDestinationsAction;
import hermes.swing.actions.DurableUnsubscribeAction;
import hermes.swing.actions.EditObjectAction;
import hermes.swing.actions.ExpandBrowserTreeAction;
import hermes.swing.actions.GetDestinationStatisticsAction;
import hermes.swing.actions.JNDIUnbindAction;
import hermes.swing.actions.PasteMessagesFromClipboardAction;
import hermes.swing.actions.RenameJNDIBindingAction;
import hermes.swing.actions.SaveAllMessagesAsXMLAction;
import hermes.swing.actions.SaveMessagesAsTextAction;
import hermes.swing.actions.SaveMessagesAsXMLAction;
import hermes.swing.actions.SaveMessagesIndividuallyAsXMLAction;
import hermes.swing.actions.SearchDestinationOrContextAction;
import hermes.swing.actions.TruncateAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.jms.Destination;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class PopupMenuFactory {
    private static final Logger log = Logger.getLogger(PopupMenuFactory.class);

    public static JidePopupMenu createFIXMessageTablePopup(final FIXMessageTable table) {
        JidePopupMenu popup = new JidePopupMenu();
        JideMenu editMenu = new JideMenu("Edit...");
        JideMenu chainMenu = new JideMenu("Chain...");
        final JCheckBoxMenuItem autoScroll = new JCheckBoxMenuItem("Autoscroll");
        chainMenu.add(new JMenuItem(new ChainByClOrdIDAction(chainMenu, table)));
        editMenu.add(new JMenuItem(ActionRegistry.getAction(CopyMessagesToClipboardAction.class)));
        popup.add((JMenuItem)editMenu);
        popup.add((JMenuItem)chainMenu);
        autoScroll.setSelected(table.isAutoScroll());
        autoScroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.setAutoscrolls(autoScroll.isSelected());
            }
        });
        return popup;
    }

    public static JidePopupMenu createBrowseActionPopup() {
        JidePopupMenu popup = new JidePopupMenu();
        JideMenu editMenu = new JideMenu("Edit...");
        JideMenu saveMenu = new JideMenu("Save...");
        editMenu.add(new JMenuItem(ActionRegistry.getAction(CutMessagesToClipboardAction.class)));
        editMenu.add(new JMenuItem(ActionRegistry.getAction(CopyMessagesToClipboardAction.class)));
        editMenu.add(new JMenuItem(ActionRegistry.getAction(PasteMessagesFromClipboardAction.class)));
        saveMenu.add(new JMenuItem(ActionRegistry.getAction(SaveMessagesAsTextAction.class)));
        saveMenu.add(new JMenuItem(ActionRegistry.getAction(SaveMessagesAsXMLAction.class)));
        saveMenu.add(new JMenuItem(ActionRegistry.getAction(SaveMessagesIndividuallyAsXMLAction.class)));
        popup.add((JMenuItem)editMenu);
        popup.add((JMenuItem)saveMenu);
        popup.add((Component)new JPopupMenu.Separator());
        popup.add(new JMenuItem(ActionRegistry.getAction(DeleteMessagesAction.class)));
        return popup;
    }

    public static JidePopupMenu createContextTreePopup(final ContextTree contextTree) {
        JidePopupMenu popupMenu = new JidePopupMenu();
        JMenuItem newSessionItem = new JMenuItem(ActionRegistry.getAction(CreateNewSessionFromJNDIAction.class));
        final JideMenu addToSessionItem = new JideMenu("Add to");
        JMenuItem createContextItem = new JMenuItem(ActionRegistry.getAction(CreateNewJNDIContextAction.class));
        JMenuItem renameBindingItem = new JMenuItem(ActionRegistry.getAction(RenameJNDIBindingAction.class));
        JMenuItem unbindItem = new JMenuItem(ActionRegistry.getAction(JNDIUnbindAction.class));
        contextTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() == null) {
                    addToSessionItem.setEnabled(false);
                } else {
                    TreeNode node = (TreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                    addToSessionItem.setEnabled(node instanceof QueueTreeNode || node instanceof TopicTreeNode || node instanceof QueueTopicTreeNode);
                }
            }
        });
        addToSessionItem.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                addToSessionItem.removeAll();
                for (final String sessionId : HermesBrowser.getBrowser().getBrowserTree().getAllHermesIds()) {
                    final JMenuItem menuItem = new JMenuItem(sessionId);
                    addToSessionItem.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            menuItem.setEnabled((Boolean)evt.getNewValue());
                        }
                    });
                    addToSessionItem.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HermesBrowser.getBrowser().getBrowserTree().doTransfer(new JMSAdministeredObjectTransferable(new HermesConfigGroup(sessionId, contextTree.getSelectedDestinations(), contextTree.getSelectedConnectionFactories())), 1);
                        }
                    });
                    contextTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                        @Override
                        public void valueChanged(TreeSelectionEvent e) {
                            if (e.getNewLeadSelectionPath() != null) {
                                TreeNode node = (TreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                                menuItem.setEnabled(node instanceof QueueTreeNode || node instanceof TopicTreeNode || node instanceof QueueTopicTreeNode);
                            }
                        }
                    });
                }
            }
        });
        popupMenu.add(newSessionItem);
        popupMenu.add((JMenuItem)addToSessionItem);
        popupMenu.add(createContextItem);
        popupMenu.add(renameBindingItem);
        popupMenu.add(unbindItem);
        return popupMenu;
    }

    public static JidePopupMenu createBrowserTreePopup(final BrowserTree tree) {
        JidePopupMenu popupMenu = new JidePopupMenu();
        final JideMenu watchMenu = new JideMenu("Watch");
        JideMenu newMenu = new JideMenu("New");
        final JideMenu recordMenu = new JideMenu("Record to");
        final JideMenu replayMenu = new JideMenu("Replay to");
        JMenuItem browseItem = new JMenuItem(ActionRegistry.getAction(BrowseDestinationOrContextAction.class));
        JMenuItem browseWithSelectorItem = new JMenuItem(ActionRegistry.getAction(BrowseDestinationWithSelectorAction.class));
        JMenuItem searchItem = new JMenuItem(ActionRegistry.getAction(SearchDestinationOrContextAction.class));
        JMenuItem truncateItem = new JMenuItem(ActionRegistry.getAction(TruncateAction.class));
        JMenuItem editItem = new JMenuItem(ActionRegistry.getAction(EditObjectAction.class));
        JMenuItem unsubscribe = new JMenuItem(ActionRegistry.getAction(DurableUnsubscribeAction.class));
        JMenuItem addSession = new JMenuItem(ActionRegistry.getAction(CreateNewSessionAction.class));
        JMenuItem addContext = new JMenuItem(ActionRegistry.getAction(CreateNewContextAction.class));
        JMenuItem addStore = new JMenuItem(ActionRegistry.getAction(CreateNewMessageStoreAction.class));
        JMenuItem copySession = new JMenuItem(ActionRegistry.getAction(CopyBrowserNodeAction.class));
        JMenuItem addQueue = new JMenuItem(ActionRegistry.getAction(AddQueueAction.class));
        JMenuItem addTopic = new JMenuItem(ActionRegistry.getAction(AddTopicAction.class));
        JMenuItem addDurableTopic = new JMenuItem(ActionRegistry.getAction(AddDurableTopicAction.class));
        JMenuItem delete = new JMenuItem(ActionRegistry.getAction(DeleteBrowserTreeNodeAction.class));
        JMenuItem discover = new JMenuItem(ActionRegistry.getAction(DiscoverDestinationsAction.class));
        JMenuItem statistics = new JMenuItem(ActionRegistry.getAction(GetDestinationStatisticsAction.class));
        final JMenuItem newWatch = new JMenuItem(ActionRegistry.getAction(CreateNewWatchAction.class));
        watchMenu.setIcon((Icon)IconCache.getIcon("hermes.watch"));
        watchMenu.setEnabled(false);
        newMenu.add(addSession);
        newMenu.add(addContext);
        newMenu.add(addQueue);
        newMenu.add(addTopic);
        newMenu.add(addDurableTopic);
        newMenu.add(addStore);
        newWatch.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                watchMenu.setEnabled(((Boolean)evt.getNewValue()).booleanValue());
            }
        });
        popupMenu.add((JMenuItem)newMenu);
        popupMenu.add(editItem);
        popupMenu.add(statistics);
        popupMenu.add(copySession);
        popupMenu.add(discover);
        popupMenu.add(delete);
        popupMenu.addSeparator();
        popupMenu.add(browseItem);
        popupMenu.add(browseWithSelectorItem);
        popupMenu.add(searchItem);
        popupMenu.add(truncateItem);
        popupMenu.add((JMenuItem)watchMenu);
        popupMenu.add((JMenuItem)recordMenu);
        popupMenu.add(new JMenuItem(ActionRegistry.getAction(SaveAllMessagesAsXMLAction.class)));
        popupMenu.add((JMenuItem)replayMenu);
        popupMenu.add(unsubscribe);
        popupMenu.addSeparator();
        popupMenu.add((Action)new CascadeBrowserTreeAction(tree));
        popupMenu.add((Action)new ExpandBrowserTreeAction(tree));
        popupMenu.add((Action)new CollapseBrowserTreeAction(tree));
        replayMenu.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                replayMenu.removeAll();
                Context ctx = HermesBrowser.getBrowser().getLoader().getContext();
                if (ctx != null) {
                    try {
                        boolean isEnabled = tree.getSelectionPath() != null && (tree.getSelectionPath().getLastPathComponent() instanceof MessageStoreDestinationTreeNode || tree.getSelectionPath().getLastPathComponent() instanceof MessageStoreTreeNode);
                        final MessageStore messageStore = tree.getSelectedMessageStore();
                        final Destination messageStoreDestination = tree.getSelectedMessageStoreDestination();
                        NamingEnumeration<Binding> iter = ctx.listBindings("");
                        while (iter.hasMoreElements()) {
                            Binding binding = iter.next();
                            if (!(binding.getObject() instanceof Hermes)) continue;
                            final Hermes hermes = (Hermes)binding.getObject();
                            JideMenu menu = new JideMenu(binding.getName());
                            JMenuItem originalItem = new JMenuItem("Original queue or topic");
                            menu.setEnabled(isEnabled);
                            originalItem.setEnabled(isEnabled);
                            originalItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ThreadPool.get().invokeLater(new ReplayMessagesFromStoreTask(messageStore, messageStoreDestination, hermes, null));
                                }
                            });
                            menu.add(originalItem);
                            HashSet<String> topics = new HashSet<String>();
                            Iterator destinations = hermes.getDestinations();
                            while (destinations.hasNext()) {
                                final DestinationConfig destinationConfig = (DestinationConfig)destinations.next();
                                if (destinationConfig.getDomain().intValue() == Domain.TOPIC.getId()) {
                                    if (topics.contains(destinationConfig.getName())) continue;
                                    topics.add(destinationConfig.getName());
                                }
                                JMenuItem item = new JMenuItem(destinationConfig.getName(), Domain.getDomain(destinationConfig.getDomain()).getIcon());
                                item.setEnabled(isEnabled);
                                item.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        ThreadPool.get().invokeLater(new ReplayMessagesFromStoreTask(messageStore, messageStoreDestination, hermes, destinationConfig));
                                    }
                                });
                                menu.add(item);
                            }
                            replayMenu.add((JMenuItem)menu);
                        }
                    }
                    catch (NamingException e1) {
                        HermesBrowser.getBrowser().showErrorDialog("Unable to list available Hermes", e1);
                    }
                }
                if (replayMenu.getItemCount() == 0) {
                    replayMenu.add(new JMenuItem("<no sessions>"));
                }
            }
        });
        recordMenu.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                boolean isEnabled;
                recordMenu.removeAll();
                Collection<MessageStore> stores = HermesBrowser.getBrowser().getBrowserTree().getMessageStores();
                boolean bl = isEnabled = tree.getSelectionPath() != null && tree.getSelectionPath().getLastPathComponent() instanceof DestinationConfigTreeNode;
                if (stores.size() > 0) {
                    for (final MessageStore store : stores) {
                        JMenuItem item = new JMenuItem(store.getId());
                        item.setEnabled(isEnabled);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Hermes hermes = HermesBrowser.getBrowser().getBrowserTree().getSelectedHermesNode().getHermes();
                                DestinationConfigTreeNode node = HermesBrowser.getBrowser().getBrowserTree().getFirstSelectedDestinationNode();
                                if (node != null) {
                                    HermesBrowser.getBrowser().getThreadPool().invokeLater(new RecordDestinationTask(hermes, node, store));
                                }
                            }
                        });
                        recordMenu.add(item);
                    }
                } else {
                    recordMenu.add(new JMenuItem("<no stores>"));
                }
            }
        });
        watchMenu.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                watchMenu.removeAll();
                try {
                    for (WatchConfig config : HermesBrowser.getBrowser().getConfig().getWatch()) {
                        final AddToExistingWatchAction action = new AddToExistingWatchAction(config);
                        watchMenu.add(new JMenuItem(action));
                        watchMenu.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                action.setEnabled((Boolean)evt.getNewValue());
                            }
                        });
                        action.setEnabled(watchMenu.isEnabled());
                    }
                    watchMenu.add(newWatch);
                }
                catch (HermesException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)((Object)ex));
                }
            }
        });
        return popupMenu;
    }
}

