/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import com.jidesoft.grid.JideTable;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.model.ClasspathConfigTableModel;
import hermes.browser.model.ClasspathGroupTableModel;
import hermes.config.ClasspathConfig;
import hermes.config.ClasspathGroupConfig;
import hermes.swing.SwingUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class ClasspathConfigTable
extends JideTable {
    private static final Logger log = Logger.getLogger(ClasspathConfigTable.class);
    private static final int COPY = 1;
    private static final int MOVE = 2;
    private ClasspathConfigTableModel model;
    private PreferencesDialog dialog;
    private File lastDirectory;
    private MouseAdapter mouseAdapter;
    private Collection groupConfigs;
    private ClasspathGroupTableModel parentModel;

    public ClasspathConfigTable(ClasspathGroupTableModel parentModel, List groupConfigs, PreferencesDialog dialog, ClasspathConfigTableModel model) {
        this.model = model;
        this.dialog = dialog;
        this.groupConfigs = groupConfigs;
        this.parentModel = parentModel;
        this.setModel(model);
        this.init();
    }

    private void init() {
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem addItem = new JMenuItem("Add JAR(s)");
        final JMenuItem removeItem = new JMenuItem("Remove JAR(s)");
        JMenu copyItem = new JMenu("Copy to");
        JMenu moveTo = new JMenu("Move to");
        popupMenu.add(addItem);
        popupMenu.add(removeItem);
        popupMenu.add(copyItem);
        popupMenu.add(moveTo);
        copyItem.addMenuListener(new IdMenuListener(copyItem, 1));
        moveTo.addMenuListener(new IdMenuListener(moveTo, 2));
        addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ClasspathConfigTable.this.doAddJAR();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        });
        removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ClasspathConfigTable.this.getSelectedRowCount() != -1) {
                    int[] rows = ClasspathConfigTable.this.getSelectedRows();
                    for (int i = 0; i < rows.length; ++i) {
                        ClasspathConfigTable.this.model.removeRow(rows[i]);
                    }
                    ClasspathConfigTable.this.dialog.setDirty();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    removeItem.setEnabled(ClasspathConfigTable.this.model.getRowCount() != 0);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(this.mouseAdapter);
        this.getTableHeader().addMouseListener(this.mouseAdapter);
        if (this.dialog != null) {
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("tableCellEditor")) {
                        ClasspathConfigTable.this.dialog.setDirty();
                    }
                }
            });
        }
        this.setAutoscrolls(true);
    }

    private void copy(ClasspathConfig config, ClasspathGroupConfig target) {
        ClasspathConfigTableModel toModel = this.parentModel.getChildModel(target);
        try {
            toModel.addItem(HermesBrowser.getConfigDAO().duplicate(config));
        }
        catch (JAXBException e) {
            HermesBrowser.getBrowser().showErrorDialog(e);
        }
    }

    public MouseAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    public void scrollRectToVisible(Rectangle aRect) {
        SwingUtils.scrollRectToVisible((Component)((Object)this), aRect);
    }

    public void doAddJAR() {
        JFileChooser fileChooser = this.lastDirectory != null ? new JFileChooser(this.lastDirectory) : new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        if (fileChooser.showOpenDialog(this.dialog) == 0) {
            Object[] options = new Object[]{"Scan", "Don't scan"};
            int n = JOptionPane.showOptionDialog((Component)((Object)HermesBrowser.getBrowser()), "Hermes will scan the JAR(s) for JMS connection factories when you confirm this dialog.\nYou only need to do this if you're not using JNDI and it can take some time if the library is very large.\nIf using BEA WebLogic select \"Don't scan\"", "Please choose", 0, 3, null, options, options[1]);
            File[] files = fileChooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                ClasspathConfig lConfig = new ClasspathConfig();
                this.lastDirectory = new File(files[i].getPath());
                lConfig.setJar(files[i].getAbsolutePath());
                if (n == 0) {
                    lConfig.setNoFactories(false);
                } else {
                    lConfig.setNoFactories(true);
                }
                this.model.addItem(lConfig);
            }
            this.dialog.setDirty();
        }
    }

    private class IdMenuListener
    implements MenuListener {
        private JMenu menu;
        int action;

        private IdMenuListener(JMenu menu, int action) {
            this.menu = menu;
            this.action = action;
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            this.menu.removeAll();
            for (final ClasspathGroupConfig config : ClasspathConfigTable.this.groupConfigs) {
                JMenuItem item = new JMenuItem(config.getId());
                this.menu.add(item);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int[] rows = ClasspathConfigTable.this.getSelectedRows();
                        block4: for (int i = 0; i < rows.length; ++i) {
                            int row = rows[i];
                            ClasspathConfig cpConfig = ClasspathConfigTable.this.model.getRowAt(row);
                            switch (IdMenuListener.this.action) {
                                case 1: {
                                    ClasspathConfigTable.this.copy(cpConfig, config);
                                    continue block4;
                                }
                                case 2: {
                                    ClasspathConfigTable.this.copy(cpConfig, config);
                                    ClasspathConfigTable.this.model.removeRow(row);
                                }
                            }
                        }
                    }
                });
            }
        }
    }
}

