/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser;

import com.jidesoft.action.CommandBarFactory;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.swing.JideMenu;
import hermes.browser.BrowserControl;
import hermes.browser.HermesBrowser;
import hermes.browser.components.PopupMenuFactory;
import hermes.browser.dialog.AboutDialog;
import hermes.swing.actions.ActionRegistry;
import hermes.swing.actions.OpenConfigAction;
import hermes.swing.actions.OpenFIXFileAction;
import hermes.swing.actions.OpenFIXURLAction;
import hermes.swing.actions.OpenXMLFileAction;
import hermes.swing.actions.PreferencesAction;
import hermes.swing.actions.SaveConfigAction;
import hermes.swing.actions.SaveMessagesAsTextAction;
import hermes.swing.actions.SaveMessagesAsXMLAction;
import hermes.swing.actions.SaveMessagesIndividuallyAsXMLAction;
import hermes.swing.actions.SendTextFileAction;
import hermes.swing.actions.SendXMLFileAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class MenuBar
extends CommandMenuBar {
    private static final Logger log = Logger.getLogger(MenuBar.class);
    private HermesBrowser hermesBrowser;
    private JideMenu fileMenu = new JideMenu("File");
    private JideMenu messageMenu = new JideMenu("Messages");
    private JideMenu actionsMenu = new JideMenu("Actions");
    private JideMenu toolMenu = new JideMenu("Options");
    private JideMenu helpMenu = new JideMenu("Help");
    private JMenuItem sendAFile = new JMenuItem();
    private JMenuItem sendXMLFile = new JMenuItem();
    private JMenuItem saveConfig = new JMenuItem(new SaveConfigAction());
    private JMenuItem openXML = new JMenuItem(new OpenXMLFileAction());
    private JMenuItem exit = new JMenuItem("Exit");
    private JMenuItem prefs = new JMenuItem(new PreferencesAction());
    private JMenuItem openConfig = new JMenuItem(new OpenConfigAction());
    private JMenuItem loadLayout = new JMenuItem("Load layout");
    private JMenuItem saveLayout = new JMenuItem("Save layout");
    private JMenuItem resetLayout = new JMenuItem("Reset layout");
    private JMenuItem help = new JMenuItem("Help");
    private JMenuItem about = new JMenuItem("About Hermes");

    public MenuBar(HermesBrowser hermesBrowser) {
        this.hermesBrowser = hermesBrowser;
        this.setStretch(true);
        this.init();
    }

    private void init() {
        this.sendAFile.setAction(ActionRegistry.getAction(SendTextFileAction.class));
        this.sendXMLFile.setAction(ActionRegistry.getAction(SendXMLFileAction.class));
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.exit(1);
            }
        });
        this.messageMenu.add(this.sendXMLFile);
        this.messageMenu.add(this.sendAFile);
        this.fileMenu.add(this.openConfig);
        this.fileMenu.add(this.openXML);
        this.fileMenu.add(ActionRegistry.getAction(OpenFIXFileAction.class));
        this.fileMenu.add(ActionRegistry.getAction(OpenFIXURLAction.class));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveConfig);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exit);
        this.toolMenu.add(this.saveLayout);
        this.toolMenu.add(this.loadLayout);
        this.toolMenu.add(this.resetLayout);
        this.toolMenu.add(this.prefs);
        this.toolMenu.add((JMenuItem)this.createLnfMenu());
        this.helpMenu.add(this.help);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.about);
        this.messageMenu.add(new JMenuItem(ActionRegistry.getAction(SaveMessagesAsTextAction.class)));
        this.messageMenu.add(new JMenuItem(ActionRegistry.getAction(SaveMessagesAsXMLAction.class)));
        this.messageMenu.add(new JMenuItem(ActionRegistry.getAction(SaveMessagesIndividuallyAsXMLAction.class)));
        Component[] components = PopupMenuFactory.createBrowserTreePopup(this.hermesBrowser.getBrowserTree()).getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.actionsMenu.add(components[i]);
        }
        this.loadLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                log.debug((Object)("loading layout profile as " + MenuBar.this.hermesBrowser.getUserProfileName()));
                MenuBar.this.hermesBrowser.getLayoutPersistence().setProfileKey(MenuBar.this.hermesBrowser.getUserProfileName());
                MenuBar.this.hermesBrowser.getLayoutPersistence().loadLayoutData();
            }
        });
        this.saveLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                log.debug((Object)("saving layout profile as " + MenuBar.this.hermesBrowser.getUserProfileName()));
                MenuBar.this.hermesBrowser.getLayoutPersistence().setProfileKey(MenuBar.this.hermesBrowser.getUserProfileName());
                MenuBar.this.hermesBrowser.getLayoutPersistence().saveLayoutData();
            }
        });
        this.resetLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                log.debug((Object)("resetting layout profile for " + MenuBar.this.hermesBrowser.getUserProfileName()));
                MenuBar.this.hermesBrowser.getLayoutPersistence().setProfileKey(MenuBar.this.hermesBrowser.getUserProfileName());
                MenuBar.this.hermesBrowser.getLayoutPersistence().resetToDefault();
            }
        });
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BrowserControl.displayURL("http://www.hermesjms.com");
            }
        });
        this.about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AboutDialog.showAboutDialog(MenuBar.this.hermesBrowser);
            }
        });
        this.add((JMenu)this.fileMenu);
        this.add((JMenu)this.messageMenu);
        this.add((JMenu)this.actionsMenu);
        this.add((JMenu)this.toolMenu);
        this.add((JMenu)this.helpMenu);
    }

    private JMenu createLnfMenu() {
        return CommandBarFactory.createLookAndFeelMenu((Container)((Object)this.hermesBrowser));
    }
}

