/*
 * Decompiled with CFR 0.152.
 */
package hermes.ant;

import hermes.Domain;
import hermes.Hermes;
import hermes.ant.AbstractTask;
import hermes.ant.HermesFactory;
import hermes.config.DestinationConfig;
import hermes.store.MessageStore;
import hermes.store.MessageStoreManager;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import org.apache.tools.ant.BuildException;

public class RecordMessagesTask
extends AbstractTask {
    private String queue;
    private String topic;
    private String jdbcURL;
    private String storeId;
    private int commitInterval = 1;

    public void execute() throws BuildException {
        MessageStore messageStore;
        DestinationConfig myDestination;
        if (this.queue == null && this.topic == null) {
            throw new BuildException("destination queue or topic is not set");
        }
        if (this.storeId == null) {
            throw new BuildException("storeId not set");
        }
        Hermes myHermes = null;
        QueueBrowser browser = null;
        try {
            Domain domain = this.queue != null ? Domain.QUEUE : Domain.TOPIC;
            String destinationName = this.queue != null ? this.queue : this.topic;
            myHermes = HermesFactory.createHermes(this.getConfig(), this.getHermes());
            myDestination = myHermes.getDestinationConfig(destinationName, domain);
            messageStore = this.jdbcURL == null ? MessageStoreManager.create(this.storeId) : MessageStoreManager.create(this.jdbcURL, this.storeId);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        try {
            int messagesRead = 0;
            browser = myHermes.createBrowser(myDestination);
            Enumeration iter = browser.getEnumeration();
            while (iter.hasMoreElements()) {
                Message m = (Message)iter.nextElement();
                if (m == null) continue;
                messageStore.store(m);
                if (++messagesRead % this.commitInterval != 0) continue;
                messageStore.checkpoint();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                messageStore.checkpoint();
                if (browser != null) {
                    browser.close();
                }
                if (myHermes != null) {
                    myHermes.close();
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public int getCommitInterval() {
        return this.commitInterval;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }
}

