/*
 * Decompiled with CFR 0.152.
 */
package hermes.ant;

import hermes.Domain;
import hermes.Hermes;
import hermes.ant.AbstractTask;
import hermes.ant.HermesFactory;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.Message;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

public class PutXMLTask
extends AbstractTask {
    private static final Logger log = Logger.getLogger(PutXMLTask.class);
    private String destination;
    private String file;

    public void execute() throws BuildException {
        if (this.destination == null) {
            throw new BuildException("destination property not set");
        }
        if (this.file == null) {
            throw new BuildException("file property for the message XML file not set");
        }
        try {
            Hermes myHermes = HermesFactory.createHermes(this.getConfig(), this.getHermes());
            Destination destination = myHermes.getDestination(this.getDestination(), Domain.UNKNOWN);
            FileInputStream istream = new FileInputStream(new File(this.getFile()));
            Collection messages = myHermes.fromXML(istream);
            istream.close();
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                myHermes.send(destination, (Message)iter.next());
            }
            if (myHermes.getTransacted()) {
                myHermes.commit();
            }
            this.log(messages.size() + " message(s) written to " + this.getDestination() + " on " + this.getHermes());
            myHermes.close();
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
            throw new BuildException(ex);
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }
}

