/*
 * Decompiled with CFR 0.152.
 */
package hermes.ant;

import hermes.Domain;
import hermes.Hermes;
import hermes.ant.AbstractTask;
import hermes.ant.HermesFactory;
import hermes.config.DestinationConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import org.apache.tools.ant.BuildException;

public class BrowseQueueTask
extends AbstractTask {
    private String queue;
    private String file;

    public void execute() throws BuildException {
        if (this.queue == null) {
            throw new BuildException("queue property not set");
        }
        if (this.file == null) {
            throw new BuildException("file property for the message XML file not set");
        }
        try {
            Hermes myHermes = HermesFactory.createHermes(this.getConfig(), this.getHermes());
            DestinationConfig destination = myHermes.getDestinationConfig(this.getQueue(), Domain.QUEUE);
            ArrayList<Message> messages = new ArrayList<Message>();
            FileOutputStream ostream = new FileOutputStream(new File(this.getFile()));
            QueueBrowser browser = myHermes.createBrowser(destination);
            Enumeration iter = browser.getEnumeration();
            while (iter.hasMoreElements()) {
                messages.add((Message)iter.nextElement());
            }
            myHermes.toXML(messages, (OutputStream)ostream);
            this.log(messages.size() + " message(s) written to file " + this.getFile() + " from " + this.getQueue() + " on " + this.getHermes());
            browser.close();
            ostream.close();
            myHermes.close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }
}

