/*
 * Decompiled with CFR 0.152.
 */
package hermes;

import hermes.JNDIConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class JNDIQueueConnectionFactory
extends JNDIConnectionFactory
implements QueueConnectionFactory {
    private static final Logger log = Logger.getLogger(JNDIQueueConnectionFactory.class);

    public synchronized QueueConnection createQueueConnection() throws JMSException {
        return this.getFactory().createQueueConnection();
    }

    public synchronized QueueConnection createQueueConnection(String arg0, String arg1) throws JMSException {
        return this.getFactory().createQueueConnection(arg0, arg1);
    }

    private QueueConnectionFactory getFactory() throws JMSException {
        QueueConnectionFactory factory;
        Context ctx = null;
        try {
            ctx = this.createContext();
            factory = (QueueConnectionFactory)ctx.lookup(this.getBinding());
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new JMSException(e.getMessage());
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e1) {
                    log.error((Object)("closing JNDI context: " + e1.getMessage()), (Throwable)e1);
                }
            }
        }
        return factory;
    }
}

