/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.ui.helper;

import java.util.List;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.DoSParam;
import wsattacker.library.intelligentdos.common.RequestType;
import wsattacker.library.intelligentdos.common.SuccessfulAttack;
import wsattacker.library.intelligentdos.helper.CommonParamItem;

public class FormatHelper {
    public static String toHTML(AttackModel attackModel) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body><table>");
        builder.append("<tr><td>Attack Name:</td><td>").append(attackModel.getDoSAttack().getName()).append("</td></tr>");
        builder.append("<tr><td>Request Type:</td><td>").append(attackModel.getRequestType()).append("</td></tr>");
        if (attackModel.getRequestType() == RequestType.TAMPERED) {
            List currentParams = attackModel.getDoSAttack().getCurrentParams();
            builder.append("<tr><td valign=\"top\" rowspan=\"").append(currentParams.size()).append("\">Parameter:</td>");
            int index = 0;
            for (DoSParam doSParam : currentParams) {
                if (index != 0) {
                    builder.append("</tr><tr>");
                }
                builder.append("<td>").append(doSParam.getDescription()).append("</td><td>").append(doSParam.getValueAsString()).append("</td>");
                ++index;
            }
            builder.append("</tr>");
            String positionString = attackModel.getPosition().toString();
            builder.append("<tr><td>Position:</td><td>").append(positionString).append("</td></tr>");
            builder.append("<tr><td>Payload Position:</td><td>").append(attackModel.getPayloadPosition()).append("</td></tr>");
        }
        builder.append("<tr><td>Number of Threads:</td><td>").append(attackModel.getNumberOfThreads()).append("</td></tr>");
        builder.append("<tr><td>Number of Requests:</td><td>").append(attackModel.getNumberOfRequests()).append("</td></tr>");
        builder.append("<tr><td>Millis between Requests:</td><td>").append(attackModel.getMilliesBetweenRequests()).append("</td></tr>");
        builder.append("</table></body></html>");
        return builder.toString();
    }

    public static String toHTML(SuccessfulAttack sa) {
        CommonParamItem paramItem = sa.getParamItem();
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body><table>");
        builder.append("<tr><td>Attack Name:</td><td>").append(sa.getDoSAttack().getName()).append("</td></tr>");
        List currentParams = sa.getDoSAttack().getCurrentParams();
        builder.append("<tr><td valign=\"top\" rowspan=\"").append(currentParams.size()).append("\">Parameter:</td>");
        int index = 0;
        for (DoSParam doSParam : currentParams) {
            if (index != 0) {
                builder.append("</tr><tr>");
            }
            builder.append("<td>").append(doSParam.getDescription()).append("</td><td>").append(doSParam.getValueAsString()).append("</td>");
            ++index;
        }
        builder.append("</tr>");
        String positionString = sa.getPosition().toString();
        builder.append("<tr><td>Position:</td><td>").append(positionString).append("</td></tr>");
        builder.append("<tr><td>Payload Position:</td><td>").append(sa.getPayloadPosition()).append("</td></tr>");
        builder.append("<tr><td>Number of Threads:</td><td>").append(paramItem.getNumberOfThreads()).append("</td></tr>");
        builder.append("<tr><td>Number of Requests:</td><td>").append(paramItem.getNumberOfRequests()).append("</td></tr>");
        builder.append("<tr><td>Millis between Requests:</td><td>").append(paramItem.getMilliesBetweenRequests()).append("</td></tr>");
        builder.append("</table></body></html>");
        return builder.toString();
    }
}

