/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.ui.helper;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.common.RequestType;
import wsattacker.library.intelligentdos.common.SuccessfulAttack;

public class ChartHelper {
    private static final double NANO_TO_MILLIES = 1000000.0;

    public static JFreeChart createDumyChart() {
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        CategoryAxis xAxis = new CategoryAxis("Type");
        NumberAxis yAxis = new NumberAxis("Value");
        yAxis.setAutoRangeIncludesZero(false);
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setFillBox(true);
        renderer.setMeanVisible(false);
        renderer.setMedianVisible(false);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        return new JFreeChart((Plot)plot);
    }

    public static JFreeChart createOverlaidChart(SuccessfulAttack sa) {
        XYSeries data1 = ChartHelper.createDatasetResponseTime(RequestType.UNTAMPERED, sa.getUntamperedMetrics());
        XYSeries data2 = ChartHelper.createDatasetResponseTime(RequestType.TAMPERED, sa.getTamperedMetrics());
        XYSeries data3 = ChartHelper.createDatasetResponseTime(RequestType.TESTPROBES, sa.getTestProbes());
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(data1);
        collection.addSeries(data2);
        collection.addSeries(data3);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        NumberAxis rangeAxis1 = new NumberAxis("duration in ms");
        XYPlot plot = new XYPlot((XYDataset)collection, (ValueAxis)new NumberAxis(""), (ValueAxis)rangeAxis1, (XYItemRenderer)renderer);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        renderer.setSeriesPaint(0, (Paint)Color.GREEN);
        renderer.setSeriesPaint(1, (Paint)Color.RED);
        renderer.setSeriesPaint(2, (Paint)Color.BLUE);
        return new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }

    private static XYSeries createDatasetResponseTime(RequestType requestType, List<Metric> metrics) {
        XYSeries series = new XYSeries((Comparable)requestType);
        int count = 1;
        for (Metric metric : metrics) {
            double e = (double)metric.getDuration() / 1000000.0;
            series.add((double)count, e);
            ++count;
        }
        return series;
    }

    public static JFreeChart createWhiskerChart(SuccessfulAttack sa) {
        BoxAndWhiskerCategoryDataset boxandwhiskercategorydataset = ChartHelper.createDataset(sa);
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setMaximumBarWidth(0.05);
        renderer.setMeanVisible(false);
        renderer.setSeriesPaint(0, (Paint)Color.GREEN);
        renderer.setSeriesPaint(1, (Paint)Color.RED);
        renderer.setSeriesPaint(2, (Paint)Color.BLUE);
        NumberAxis numberAxis = new NumberAxis("duration in ms");
        CategoryPlot categoryplot = new CategoryPlot((CategoryDataset)boxandwhiskercategorydataset, new CategoryAxis(""), (ValueAxis)numberAxis, (CategoryItemRenderer)renderer);
        categoryplot.setDomainGridlinesVisible(true);
        categoryplot.setRangePannable(true);
        NumberAxis numberaxis = (NumberAxis)categoryplot.getRangeAxis();
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        JFreeChart jFreeChart = new JFreeChart("", new Font("SansSerif", 1, 14), (Plot)categoryplot, true);
        jFreeChart.removeLegend();
        return jFreeChart;
    }

    private static BoxAndWhiskerCategoryDataset createDataset(SuccessfulAttack sa) {
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        ChartHelper.add(dataset, RequestType.UNTAMPERED, sa.getUntamperedMetrics());
        ChartHelper.add(dataset, RequestType.TAMPERED, sa.getTamperedMetrics());
        ChartHelper.add(dataset, RequestType.TESTPROBES, sa.getTestProbeMetrics());
        return dataset;
    }

    private static void add(DefaultBoxAndWhiskerCategoryDataset dataset, RequestType requestType, List<Metric> metrics) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (Metric metric : metrics) {
            double e = (double)metric.getDuration() / 1000000.0;
            list.add(e);
        }
        dataset.add(list, (Comparable)((Object)("Series " + requestType)), (Comparable)requestType);
    }
}

