/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.persistence;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import wsattacker.library.intelligentdos.common.Threshold;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.plugin.intelligentdos.model.ResultModel;
import wsattacker.plugin.intelligentdos.persistence.DoSAttackJAXB;
import wsattacker.plugin.intelligentdos.persistence.ThresholdJAXB;

@XmlRootElement
public class AttackMetaDataJAXB {
    private Date start;
    private Date stop;
    private double maximumRequestsPerSecond;
    private List<DoSAttackJAXB> notPossible = Lists.newArrayList();
    private List<ThresholdJAXB> thresholds = Lists.newArrayList();

    public Date getStart() {
        return new Date(this.start.getTime());
    }

    public void setStart(Date start) {
        this.start = new Date(start.getTime());
    }

    public Date getStop() {
        return new Date(this.stop.getTime());
    }

    public void setStop(Date stop) {
        this.stop = new Date(stop.getTime());
    }

    public double getMaximumRequestsPerSecond() {
        return this.maximumRequestsPerSecond;
    }

    public void setMaximumRequestsPerSecond(double maximumRequestsPerSecond) {
        this.maximumRequestsPerSecond = maximumRequestsPerSecond;
    }

    public List<DoSAttackJAXB> getNotPossible() {
        return this.notPossible;
    }

    public void setNotPossible(List<DoSAttackJAXB> notPossible) {
        this.notPossible = notPossible;
    }

    public List<ThresholdJAXB> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(List<ThresholdJAXB> threshold) {
        this.thresholds = threshold;
    }

    public ResultModel toResultModel() {
        ResultModel resultModel = new ResultModel();
        resultModel.setStartDate(this.start);
        resultModel.setStopDate(this.stop);
        resultModel.setMaximumRequestsPerSecond(this.maximumRequestsPerSecond);
        for (DoSAttackJAXB doSAttackJAXB : this.notPossible) {
            resultModel.getNotPossible().add(doSAttackJAXB.toDoSAttack());
        }
        for (ThresholdJAXB thresholdJAXB : this.thresholds) {
            resultModel.getThresholds().add(thresholdJAXB.toThreshold());
        }
        return resultModel;
    }

    public static AttackMetaDataJAXB fromResultModel(ResultModel resultModel) {
        AttackMetaDataJAXB attackMetaDataJAXB = new AttackMetaDataJAXB();
        attackMetaDataJAXB.setStart(resultModel.getStartDate());
        attackMetaDataJAXB.setStop(resultModel.getStopDate());
        attackMetaDataJAXB.setMaximumRequestsPerSecond(resultModel.getMaximumRequestsPerSecond());
        for (DoSAttack doSAttack : resultModel.getNotPossible()) {
            attackMetaDataJAXB.notPossible.add(DoSAttackJAXB.fromDoSAttack(doSAttack));
        }
        for (Threshold threshold : resultModel.getThresholds()) {
            attackMetaDataJAXB.thresholds.add(ThresholdJAXB.fromThreshold(threshold));
        }
        return attackMetaDataJAXB;
    }
}

