/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.listener;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.plugin.intelligentdos.listener.AttackPerformedListener;

public class PersistAttackListener
implements AttackPerformedListener {
    private static final String SEPARATOR = ", ";
    private File baseDir;

    public PersistAttackListener(String baseDirAsString) {
        this(new File(baseDirAsString));
    }

    public PersistAttackListener(File baseDir) {
        this.baseDir = baseDir == null ? new File(System.getProperty("java.io.tmpdir")) : baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attackPerformed(int count, AttackModel attackModel) {
        File file = new File(this.baseDir, attackModel.getDoSAttack().getName());
        if (!(file = new File(file, count + "_" + attackModel.getRequestType() + ".txt")).getParentFile().exists() && !file.getParentFile().mkdirs()) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.defaultCharset()));
            for (Metric metric : attackModel.getMetrics()) {
                writer.write(metric.getDuration() + SEPARATOR + metric.getContent() + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

