/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter.gradient;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.jdesktop.swingx.painter.gradient.AbstractGradientPainter;

public class LinearGradientPainter
extends AbstractGradientPainter {
    public static final LinearGradientPaint ORANGE_DELIGHT = new LinearGradientPaint((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 1.0), new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(248, 192, 75), new Color(253, 152, 6), new Color(243, 133, 0), new Color(254, 124, 0)});
    public static final LinearGradientPaint BLACK_STAR = new LinearGradientPaint((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 1.0), new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(54, 62, 78), new Color(32, 39, 55), new Color(74, 82, 96), new Color(123, 132, 145)});
    public static final LinearGradientPaint BLACK_PERSPECTIVE = new LinearGradientPaint((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 1.0), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{Color.BLACK, new Color(110, 110, 110), Color.BLACK});
    private LinearGradientPaint paint;

    public LinearGradientPainter() {
    }

    public LinearGradientPainter(LinearGradientPaint paint) {
        this.paint = paint;
    }

    public void setGradientPaint(LinearGradientPaint paint) {
        LinearGradientPaint old = this.getGradientPaint();
        this.paint = paint;
        this.firePropertyChange("gradientPaint", old, this.getGradientPaint());
    }

    public LinearGradientPaint getGradientPaint() {
        return this.paint;
    }

    protected Paint calculateSizedPaint(int width, int height) {
        LinearGradientPaint paint = this.getGradientPaint();
        if (paint == null) {
            return null;
        }
        Point2D startPoint = paint.getStartPoint();
        Point2D endPoint = paint.getEndPoint();
        double x1 = this.isResizeHorizontal() ? startPoint.getX() * (double)width : startPoint.getX();
        double y1 = this.isResizeVertical() ? startPoint.getY() * (double)height : startPoint.getY();
        double x2 = this.isResizeHorizontal() ? endPoint.getX() * (double)width : endPoint.getX();
        double y2 = this.isResizeVertical() ? endPoint.getY() * (double)height : endPoint.getY();
        startPoint = new Point2D.Double(x1, y1);
        endPoint = new Point2D.Double(x2, y2);
        return new LinearGradientPaint(startPoint, endPoint, paint.getFractions(), paint.getColors(), paint.getCycleMethod(), paint.getColorSpace(), paint.getTransform());
    }
}

