/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.image.AbstractFilter;

public class ColorTintFilter
extends AbstractFilter {
    private final Color mixColor;
    private final float mixValue;

    public ColorTintFilter(Color mixColor, float mixValue) {
        if (mixColor == null) {
            throw new IllegalArgumentException("mixColor cannot be null");
        }
        this.mixColor = mixColor;
        if (mixValue < 0.0f) {
            mixValue = 0.0f;
        } else if (mixValue > 1.0f) {
            mixValue = 1.0f;
        }
        this.mixValue = mixValue;
    }

    public float getMixValue() {
        return this.mixValue;
    }

    public Color getMixColor() {
        return this.mixColor;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        GraphicsUtilities.getPixels(src, 0, 0, width, height, pixels);
        this.mixColor(pixels);
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }

    private void mixColor(int[] pixels) {
        int mix_a = this.mixColor.getAlpha();
        int mix_r = this.mixColor.getRed();
        int mix_g = this.mixColor.getBlue();
        int mix_b = this.mixColor.getGreen();
        for (int i = 0; i < pixels.length; ++i) {
            int argb = pixels[i];
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            a = (int)((float)a * (1.0f - this.mixValue) + (float)mix_a * this.mixValue);
            r = (int)((float)r * (1.0f - this.mixValue) + (float)mix_r * this.mixValue);
            g = (int)((float)g * (1.0f - this.mixValue) + (float)mix_g * this.mixValue);
            b = (int)((float)b * (1.0f - this.mixValue) + (float)mix_b * this.mixValue);
            pixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }
}

