/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.UIManager;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;

public class AlternateRowHighlighter
extends Highlighter {
    private static final Color defaultOddRowColor = Color.white;
    private static final Color defaultEvenRowColor = new Color(240, 240, 224);
    public static final Highlighter beige = new AlternateRowHighlighter(Color.white, new Color(245, 245, 220), null, true);
    public static final Highlighter linePrinter = new AlternateRowHighlighter(Color.white, new Color(204, 204, 255), null, true);
    public static final Highlighter classicLinePrinter = new AlternateRowHighlighter(Color.white, new Color(204, 255, 204), null, true);
    public static final Highlighter floralWhite = new AlternateRowHighlighter(Color.white, new Color(255, 250, 240), null, true);
    public static final Highlighter quickSilver = new AlternateRowHighlighter(Color.white, defaultEvenRowColor, null, true);
    public static final AlternateRowHighlighter genericGrey = new AlternateRowHighlighter(Color.white, new Color(229, 229, 229), null, true);
    private Color oddRowBackground = defaultOddRowColor;
    private Color evenRowBackground = defaultEvenRowColor;
    private int linesPerGroup = 1;

    public AlternateRowHighlighter() {
    }

    public AlternateRowHighlighter(Color oddRowBackground, Color evenRowBackground, Color foreground) {
        this(oddRowBackground, evenRowBackground, foreground, false);
    }

    public AlternateRowHighlighter(Color oddRowBackground, Color evenRowBackground, Color foreground, boolean immutable) {
        super(oddRowBackground, foreground, immutable);
        this.oddRowBackground = oddRowBackground;
        this.evenRowBackground = evenRowBackground;
    }

    public Color getOddRowBackground() {
        return this.oddRowBackground;
    }

    public void setOddRowBackground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.oddRowBackground = color;
        this.fireStateChanged();
    }

    public Color getEvenRowBackground() {
        return this.evenRowBackground;
    }

    public void setEvenRowBackground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.evenRowBackground = color;
        this.fireStateChanged();
    }

    protected Color computeUnselectedBackground(Component renderer, ComponentAdapter adapter) {
        return this.isOddRow(adapter) ? this.oddRowBackground : this.evenRowBackground;
    }

    protected boolean isOddRow(ComponentAdapter adapter) {
        return adapter.row / this.getLinesPerGroup() % 2 == 0;
    }

    public int getLinesPerGroup() {
        return this.linesPerGroup;
    }

    public void setLinesPerGroup(int linesPerGroup) {
        if (this.isImmutable()) {
            return;
        }
        this.linesPerGroup = Math.max(1, linesPerGroup);
        this.fireStateChanged();
    }

    public static class UIAlternateRowHighlighter
    extends AlternateRowHighlighter
    implements Highlighter.UIHighlighter {
        private HashMap<Color, Color> colorMap;

        public UIAlternateRowHighlighter() {
            super(Color.WHITE, null, null);
            this.initColorMap();
            this.updateUI();
        }

        public void updateUI() {
            Color selection = UIManager.getColor("Table.selectionBackground");
            Color highlight = this.getMappedColor(selection);
            this.setEvenRowBackground(highlight);
        }

        private Color getMappedColor(Color selection) {
            Color color = this.colorMap.get(selection);
            if (color == null) {
                color = genericGrey.getEvenRowBackground();
            }
            return color;
        }

        private void initColorMap() {
            this.colorMap = new HashMap();
            this.colorMap.put(new Color(184, 207, 229), new Color(230, 238, 246));
            this.colorMap.put(new Color(49, 106, 197), new Color(224, 233, 246));
            this.colorMap.put(new Color(178, 180, 191), new Color(235, 235, 236));
            this.colorMap.put(new Color(147, 160, 112), new Color(228, 231, 219));
            this.colorMap.put(new Color(10, 36, 106), new Color(218, 222, 233));
            this.colorMap.put(new Color(0, 0, 128), new Color(218, 222, 233));
            this.colorMap.put(new Color(205, 205, 255), new Color(235, 235, 255));
            this.colorMap.put(new Color(56, 117, 215), new Color(237, 243, 254));
        }
    }
}

