/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.ColumnHeaderRenderer;
import org.jdesktop.swingx.table.TableColumnExt;

public class JXTableHeader
extends JTableHeader
implements TableColumnModelExtListener {
    private SortGestureRecognizer sortGestureRecognizer;
    private MouseInputListener headerListener;

    public JXTableHeader() {
    }

    public JXTableHeader(TableColumnModel columnModel) {
        super(columnModel);
    }

    public void setTable(JTable table) {
        super.setTable(table);
        if (this.getXTable() != null) {
            this.installHeaderListener();
        } else {
            this.uninstallHeaderListener();
        }
    }

    public void columnPropertyChange(PropertyChangeEvent event) {
        if (this.isColumnEvent(event)) {
            return;
        }
        this.resizeAndRepaint();
    }

    protected boolean isColumnEvent(PropertyChangeEvent event) {
        return "width".equals(event.getPropertyName()) || "preferredWidth".equals(event.getPropertyName()) || "visible".equals(event.getPropertyName());
    }

    public String getToolTipText(MouseEvent event) {
        String columnToolTipText = this.getColumnToolTipText(event);
        return columnToolTipText != null ? columnToolTipText : super.getToolTipText(event);
    }

    protected String getColumnToolTipText(MouseEvent event) {
        if (this.getXTable() == null) {
            return null;
        }
        int column = this.columnAtPoint(event.getPoint());
        if (column < 0) {
            return null;
        }
        TableColumnExt columnExt = this.getXTable().getColumnExt(column);
        return columnExt != null ? columnExt.getToolTipText() : null;
    }

    public JXTable getXTable() {
        if (!(this.getTable() instanceof JXTable)) {
            return null;
        }
        return (JXTable)this.getTable();
    }

    public TableCellRenderer getCellRenderer(int columnIndex) {
        TableCellRenderer renderer = this.getColumnModel().getColumn(columnIndex).getHeaderRenderer();
        return renderer != null ? renderer : this.getDefaultRenderer();
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        pref = this.getPreferredSize(pref);
        pref.height = this.getMinimumHeight(pref.height);
        return pref;
    }

    protected Dimension getPreferredSize(Dimension pref) {
        int height = pref.height;
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableCellRenderer renderer = this.getCellRenderer(i);
            Component comp = renderer.getTableCellRendererComponent(this.table, this.getColumnModel().getColumn(i).getHeaderValue(), false, false, -1, i);
            height = Math.max(height, comp.getPreferredSize().height);
        }
        pref.height = height;
        return pref;
    }

    protected int getMinimumHeight(int height) {
        if (height == 0 && this.getXTable() != null && this.getXTable().isColumnControlVisible()) {
            TableCellRenderer renderer = this.getDefaultRenderer();
            Component comp = renderer.getTableCellRendererComponent(this.getTable(), "dummy", false, false, -1, -1);
            height = comp.getPreferredSize().height;
        }
        return height;
    }

    public void updateUI() {
        super.updateUI();
        if (this.getDefaultRenderer() instanceof JComponent) {
            ((JComponent)((Object)this.getDefaultRenderer())).updateUI();
        }
    }

    public TableColumn getDraggedColumn() {
        return this.isVisible(this.draggedColumn) ? this.draggedColumn : null;
    }

    private boolean isVisible(TableColumn column) {
        return this.getViewIndexForColumn(column) >= 0;
    }

    private int getViewIndexForColumn(TableColumn aColumn) {
        if (aColumn == null) {
            return -1;
        }
        TableColumnModel cm = this.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    protected TableCellRenderer createDefaultRenderer() {
        return ColumnHeaderRenderer.createColumnHeaderRenderer();
    }

    public SortGestureRecognizer getSortGestureRecognizer() {
        if (this.sortGestureRecognizer == null) {
            this.sortGestureRecognizer = this.createSortGestureRecognizer();
        }
        return this.sortGestureRecognizer;
    }

    public void setSortGestureRecognizer(SortGestureRecognizer recognizer) {
        this.sortGestureRecognizer = recognizer;
    }

    protected SortGestureRecognizer createSortGestureRecognizer() {
        return new SortGestureRecognizer();
    }

    protected void installHeaderListener() {
        if (this.headerListener == null) {
            this.headerListener = new HeaderListener();
            this.addMouseListener(this.headerListener);
            this.addMouseMotionListener(this.headerListener);
        }
    }

    protected void uninstallHeaderListener() {
        if (this.headerListener != null) {
            this.removeMouseListener(this.headerListener);
            this.removeMouseMotionListener(this.headerListener);
            this.headerListener = null;
        }
    }

    public static class SortGestureRecognizer {
        public boolean isResetSortOrderGesture(MouseEvent e) {
            return this.isSortOrderGesture(e) && this.isResetModifier(e);
        }

        protected boolean isResetModifier(MouseEvent e) {
            return (e.getModifiersEx() & 0x40) == 64;
        }

        public boolean isToggleSortOrderGesture(MouseEvent e) {
            return this.isSortOrderGesture(e) && !this.isResetModifier(e);
        }

        public boolean isSortOrderGesture(MouseEvent e) {
            return e.getClickCount() == 1;
        }
    }

    private class HeaderListener
    implements MouseInputListener {
        private TableColumn cachedResizingColumn;

        private HeaderListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            if (this.isInResizeRegion(e)) {
                this.doResize(e);
            } else {
                this.doSort(e);
            }
        }

        private boolean shouldIgnore(MouseEvent e) {
            return !SwingUtilities.isLeftMouseButton(e) || !JXTableHeader.this.table.isEnabled();
        }

        private void doSort(MouseEvent e) {
            JXTable table = JXTableHeader.this.getXTable();
            if (!table.isSortable()) {
                return;
            }
            if (JXTableHeader.this.getSortGestureRecognizer().isResetSortOrderGesture(e)) {
                table.resetSortOrder();
                JXTableHeader.this.repaint();
            } else if (JXTableHeader.this.getSortGestureRecognizer().isToggleSortOrderGesture(e)) {
                int column = JXTableHeader.this.columnAtPoint(e.getPoint());
                if (column >= 0) {
                    table.toggleSortOrder(column);
                }
                this.uncacheResizingColumn();
                JXTableHeader.this.repaint();
            }
        }

        private void doResize(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            int column = JXTableHeader.this.getViewIndexForColumn(this.cachedResizingColumn);
            if (column >= 0) {
                JXTableHeader.this.getXTable().packColumn(column, 5);
            }
            this.uncacheResizingColumn();
        }

        public void mouseReleased(MouseEvent e) {
            this.cacheResizingColumn(e);
        }

        public void mousePressed(MouseEvent e) {
            this.cacheResizingColumn(e);
        }

        private void cacheResizingColumn(MouseEvent e) {
            if (!JXTableHeader.this.getSortGestureRecognizer().isSortOrderGesture(e)) {
                return;
            }
            TableColumn column = JXTableHeader.this.getResizingColumn();
            if (column != null) {
                this.cachedResizingColumn = column;
            }
        }

        private void uncacheResizingColumn() {
            this.cachedResizingColumn = null;
        }

        private boolean isInResizeRegion(MouseEvent e) {
            return this.cachedResizingColumn != null;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.uncacheResizingColumn();
        }

        public void mouseDragged(MouseEvent e) {
            this.uncacheResizingColumn();
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

