/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.timestampelement;

import java.text.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.signatureWrapping.util.timestamp.TimestampUpdateHelper;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.base.AbstractDetectionFilter;
import wsattacker.library.xmlencryptionattack.timestampelement.TimestampBase;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public final class TimestampElement
extends TimestampBase {
    private Element m_CreatedPayload = null;
    private Element m_ExpiresPayload = null;
    private Element m_CreatedElement = null;
    private Element m_ExpiresElement = null;

    public TimestampElement(Element timestamp) {
        this.initTimestamp(timestamp);
    }

    private void initTimestamp(Element timestamp) throws IllegalArgumentException {
        String warning;
        this.m_TimestampElement = timestamp;
        for (Node cur = this.m_TimestampElement.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (cur.getNodeType() != 1) continue;
            if ("Created".equals(cur.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(cur.getNamespaceURI())) {
                this.m_CreatedElement = (Element)cur;
            }
            if (!"Expires".equals(cur.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(cur.getNamespaceURI())) continue;
            this.m_ExpiresElement = (Element)cur;
        }
        if (this.m_CreatedElement == null) {
            warning = "No Created Element in Timestamp detected";
            AbstractDetectionFilter.LOG.warn((Object)warning);
            throw new IllegalArgumentException(warning);
        }
        if (this.m_ExpiresElement == null) {
            warning = "No expires Element in Timestamp detected";
            AbstractDetectionFilter.LOG.warn((Object)warning);
            throw new IllegalArgumentException(warning);
        }
    }

    @Override
    public void updateTimeStamp(Document doc) {
        TimestampUpdateHelper helper = null;
        if (null != this.getCreatedPayload() && null != this.getExpiresPayload()) {
            Element ceatedPay = DomUtilities.findCorrespondingElement((Document)doc, (Element)this.getCreatedPayload());
            Element expPay = DomUtilities.findCorrespondingElement((Document)doc, (Element)this.getExpiresPayload());
            try {
                helper = new TimestampUpdateHelper(ceatedPay.getTextContent(), expPay.getTextContent());
            }
            catch (ParseException ex) {
                String warning = "Timestampformat could not be handled";
                AbstractDetectionFilter.LOG.warn((Object)warning);
                try {
                    throw new InvalidPayloadException(warning);
                }
                catch (InvalidPayloadException ex1) {
                    AbstractDetectionFilter.LOG.error((Object)ex);
                }
            }
            ceatedPay.setTextContent(helper.getStart());
            expPay.setTextContent(helper.getEnd());
        }
    }

    @Override
    public void setTimeStampPayloads(Element pay) {
        this.setDetectionPayElement(pay);
        for (Node cur = this.getDetectionPayElement().getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (cur.getNodeType() != 1) continue;
            if ("Created".equals(cur.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(cur.getNamespaceURI())) {
                this.setCreatedPayload((Element)cur);
            }
            if (!"Expires".equals(cur.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(cur.getNamespaceURI())) continue;
            this.setExpiresPayload((Element)cur);
        }
    }

    public Element getCreatedElement() {
        return this.m_CreatedElement;
    }

    public void setCreatedElement(Element createdElement) {
        this.m_CreatedElement = createdElement;
    }

    public Element getExpiresElement() {
        return this.m_ExpiresElement;
    }

    public void setExpiresElement(Element expiresElement) {
        this.m_ExpiresElement = expiresElement;
    }

    public Element getCreatedPayload() {
        return this.m_CreatedPayload;
    }

    public void setCreatedPayload(Element createdPayload) {
        this.m_CreatedPayload = createdPayload;
    }

    public Element getExpiresPayload() {
        return this.m_ExpiresPayload;
    }

    public void setExpiresPayload(Element expiresPayload) {
        this.m_ExpiresPayload = expiresPayload;
    }

    public void setCreatedValue(String createdVal) {
        this.m_CreatedElement.setTextContent(createdVal);
    }

    public void setExpiresValue(String expiresVal) {
        this.m_ExpiresElement.setTextContent(expiresVal);
    }
}

