/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.encryptedelements;

import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.xmlencryptionattack.encryptedelements.CipherDataChildIF;
import wsattacker.library.xmlencryptionattack.encryptedelements.CipherReferenceElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.CipherValueElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.KeyInfoElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public abstract class AbstractEncryptionElement {
    protected CipherDataChildIF m_CipherDataChild = null;
    protected KeyInfoElement m_KeyInfoElement = null;
    protected String m_EncryptionMethod = null;
    protected String m_IdValue = null;
    protected String m_MimeType = null;
    protected String m_Type = null;
    protected Element m_EncryptedElement = null;
    protected Element m_CipherDataElement = null;
    protected final ElementAttackProperties m_AttackProperties = new ElementAttackProperties();
    protected static final Logger LOG = Logger.getLogger(AbstractEncryptionElement.class);

    public ElementAttackProperties getAttackProperties() {
        return this.m_AttackProperties;
    }

    public CipherDataChildIF getCipherDataChild() {
        return this.m_CipherDataChild;
    }

    public KeyInfoElement getKeyInfoElement() {
        return this.m_KeyInfoElement;
    }

    public Element getEncryptedElement() {
        return this.m_EncryptedElement;
    }

    public String getEncryptionMethod() {
        return this.m_EncryptionMethod;
    }

    public String getIdValue() {
        return this.m_IdValue;
    }

    public String getMimeType() {
        return this.m_MimeType;
    }

    public String getType() {
        return this.m_Type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initEncryptionElement(Element encDataElement) {
        if (null == encDataElement) throw new IllegalArgumentException("parameter 'encDataElement' must not be null");
        this.m_EncryptedElement = encDataElement;
        List cipherData = null;
        cipherData = DomUtilities.findChildren((Node)encDataElement, (String)"CipherData", (String)"http://www.w3.org/2001/04/xmlenc#");
        List keyInfoElements = DomUtilities.findChildren((Node)encDataElement, (String)"KeyInfo", null, (boolean)true);
        if (0 < keyInfoElements.size()) {
            this.m_KeyInfoElement = new KeyInfoElement((Element)keyInfoElements.get(0));
        }
        if (1 != cipherData.size()) throw new IllegalArgumentException("parameter 'cipherData' size must not be empty or bigger than one");
        List cipherDataChild = null;
        cipherDataChild = DomUtilities.findChildren((Node)((Node)cipherData.get(0)), (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        this.m_CipherDataElement = (Element)cipherData.get(0);
        if (1 == cipherDataChild.size()) {
            this.m_CipherDataChild = new CipherValueElement((Element)cipherDataChild.get(0));
        } else {
            if (!cipherDataChild.isEmpty()) throw new IllegalArgumentException("parameter 'cipherDataChild'->CipherValue size must not be bigger than one");
            cipherDataChild = DomUtilities.findChildren((Node)((Node)cipherData.get(0)), (String)"CipherReference", (String)"http://www.w3.org/2001/04/xmlenc#");
            if (1 == cipherDataChild.size()) {
                this.m_CipherDataChild = new CipherReferenceElement((Element)cipherDataChild.get(0));
            } else {
                if (1 > cipherDataChild.size()) throw new IllegalArgumentException("no 'cipherDataChild' detected");
                throw new IllegalArgumentException("parameter 'cipherDataChild'->CipherReference size must not be bigger than one");
            }
        }
        this.m_EncryptionMethod = ((Element)DomUtilities.findChildren((Node)this.m_EncryptedElement, (String)"EncryptionMethod", null).get(0)).getAttribute("Algorithm");
        this.m_IdValue = this.m_EncryptedElement.getAttribute("Id");
        this.m_MimeType = this.m_EncryptedElement.getAttribute("MimeType");
        this.m_Type = this.m_EncryptedElement.getAttribute("Type");
    }

    public Element getCipherDataElement() {
        return this.m_CipherDataElement;
    }

    public boolean isValid(String value) {
        boolean isValid = true;
        if (value.length() >= 3) {
            try {
                DomUtilities.stringToDom((String)value);
            }
            catch (Exception e) {
                LOG.error((Object)("Payload.isValid() Error: " + e.getLocalizedMessage()));
                isValid = false;
            }
        }
        return isValid;
    }
}

