/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.detectionengine.filter.concrete;

import java.util.List;
import java.util.Random;
import org.opensaml.xml.util.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.base.AbstractDetectionFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AbstractDetectionInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AvoidedDocErrorInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.util.CryptoConstants;
import wsattacker.library.xmlencryptionattack.util.HelperFunctions;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class AvoidedDocErrorFilter
extends AbstractDetectionFilter {
    private final ErrorGenerator m_ErrorGen = ErrorGenerator.RANDOM;
    private AbstractEncryptionElement m_PayLoadInput = null;

    public AvoidedDocErrorFilter(DetectFilterEnum filterType) {
        this.mFilterType = filterType;
        this.m_OutputFilter = new AvoidedDocErrorInfo(filterType);
    }

    @Override
    public AbstractDetectionInfo process() {
        String newCipherVal = null;
        if (null == this.m_PayLoadInput) {
            throw new IllegalArgumentException("payload input not set");
        }
        if (null == this.m_PayLoadInput.getAttackProperties().getAttackPayloadElement()) {
            throw new IllegalArgumentException("no attack payload is set => first you have to generate an attack message for payload");
        }
        Element attackPay = this.m_PayLoadInput.getAttackProperties().getAttackPayloadElement();
        Document errDocument = DomUtilities.createNewDomFromNode((Node)attackPay.getOwnerDocument().getDocumentElement());
        Element errPayElement = DomUtilities.findCorrespondingElement((Document)errDocument, (Element)attackPay);
        List cipherDataErrPay = DomUtilities.findChildren((Node)errPayElement, (String)"CipherData", (String)"http://www.w3.org/2001/04/xmlenc#");
        if (1 != cipherDataErrPay.size()) {
            throw new IllegalArgumentException("Encrypted element has not one CipherData-Element => should never happen");
        }
        List cipherValErrPay = DomUtilities.findChildren((Node)((Node)cipherDataErrPay.get(0)), (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        if (1 != cipherValErrPay.size()) {
            throw new IllegalArgumentException("Encrypted element has not one CipherValue-Element => should never happen");
        }
        switch (this.m_ErrorGen) {
            case RANDOM: {
                newCipherVal = this.generateRandomPayload();
                break;
            }
            case NO_RANDOM: {
                newCipherVal = this.generateNoRandomPayload();
            }
        }
        ((Element)cipherValErrPay.get(0)).setTextContent(newCipherVal);
        ((AvoidedDocErrorInfo)this.m_OutputFilter).setOriginalPayInput(this.m_PayLoadInput);
        ((AvoidedDocErrorInfo)this.m_OutputFilter).setErrorPayOutput(errPayElement);
        ((AvoidedDocErrorInfo)this.m_OutputFilter).setErrorDocument(errDocument);
        ((AvoidedDocErrorInfo)this.m_OutputFilter).setAvoidedDocument(this.m_InputFilter);
        return (AvoidedDocErrorInfo)this.m_OutputFilter;
    }

    private String generateRandomPayload() {
        Random r = new Random();
        CryptoConstants.Algorithm algo = null;
        byte[] randomBytes = null;
        if (this.m_PayLoadInput instanceof EncryptedKeyElement) {
            EncryptedDataElement encData = null;
            encData = HelperFunctions.getEncDataOfEncryptedKey((EncryptedKeyElement)this.m_PayLoadInput);
            algo = CryptoConstants.getAlgorithm(encData.getEncryptionMethod());
            randomBytes = new byte[algo.KEY_SIZE];
        } else {
            algo = CryptoConstants.getAlgorithm(this.m_PayLoadInput.getEncryptionMethod());
            randomBytes = new byte[algo.BLOCK_SIZE * 2];
        }
        ((AvoidedDocErrorInfo)this.m_OutputFilter).setAlgoOfSymmtricBlockCipher(algo);
        r.nextBytes(randomBytes);
        return Base64.encodeBytes((byte[])randomBytes);
    }

    private String generateNoRandomPayload() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setPayloadInput(AbstractEncryptionElement input) {
        this.m_PayLoadInput = input;
    }

    public AbstractEncryptionElement getPayloadInput() {
        return this.m_PayLoadInput;
    }

    public static enum ErrorGenerator {
        NO_RANDOM,
        RANDOM;

    }
}

