/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.signatureWrapping.util.signature.ReferenceElement;
import wsattacker.library.signatureWrapping.util.signature.SignatureElement;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.Pipeline;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.base.AbstractDetectionFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AbstractDetectionInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.EncryptionInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.SignatureInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.TimestampInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractRefElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.DataReferenceElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.KeyInfoElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.KeyReferenceElement;
import wsattacker.library.xmlencryptionattack.timestampelement.TimestampBase;
import wsattacker.library.xmlencryptionattack.timestampelement.TimestampElement;

public class DetectionManager {
    private Pipeline m_Pipeline;
    private DetectionReport m_DetectionReport;
    private Document m_InputFile = null;
    public static final Logger LOG = Logger.getLogger(DetectionManager.class);

    public Document getInputFile() {
        return this.m_InputFile;
    }

    public void setInputFile(Document inputFile) {
        this.m_InputFile = inputFile;
    }

    public DetectionReport getDetectionReport() {
        return this.m_DetectionReport;
    }

    public void setDetectionReport(DetectionReport detectionReport) {
        this.m_DetectionReport = detectionReport;
    }

    public DetectionManager(Pipeline pipeline, Document doc) {
        this.m_Pipeline = pipeline;
        this.m_InputFile = doc;
        this.m_DetectionReport = new DetectionReport();
        this.m_DetectionReport.setRawFile(doc);
    }

    public void startDetection() throws InvalidPayloadException {
        AbstractDetectionFilter detectFilter = null;
        AbstractDetectionInfo detectedInfo = null;
        Iterator<AbstractDetectionFilter> it = this.m_Pipeline.getPipelineIterator();
        while (it.hasNext()) {
            detectFilter = it.next();
            if (null != this.m_InputFile) {
                detectFilter.setInputDocument(this.m_InputFile);
            }
            detectedInfo = detectFilter.process();
            this.m_DetectionReport.addDetectionInfo(detectedInfo.getInfoType(), detectedInfo);
        }
        if (null != this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.SIGNATUREFILTER)) {
            if (null != this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.ENCRYPTIONFILTER)) {
                this.detectSignedEncryptionParts();
            }
            if (null != this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.TIMESTAMPFILTER)) {
                this.detectSignedTimeStamps();
            }
        }
    }

    public Pipeline getPipeline() {
        return this.m_Pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.m_Pipeline = pipeline;
    }

    public void addFilterToPipeline(AbstractDetectionFilter filter) {
        this.m_Pipeline.addFilerToPipline(filter);
    }

    private void detectSignedEncryptionParts() throws InvalidPayloadException {
        List<SignatureElement> sigList = ((SignatureInfo)this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.SIGNATUREFILTER)).getSignatureElements();
        this.detectSignedEncryptionKeyParts(sigList);
        this.detectSignedEncryptionDataParts(sigList);
    }

    private void detectSignedEncryptionDataParts(List<SignatureElement> sigList) {
        List<EncryptedDataElement> encDataList = ((EncryptionInfo)this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.ENCRYPTIONFILTER)).getEncryptedDataElements();
        for (int i = 0; i < encDataList.size(); ++i) {
            for (int j = 0; j < sigList.size(); ++j) {
                if (encDataList.get(i) instanceof EncryptedDataElement) {
                    List sigRefs = sigList.get(j).getReferences();
                    ElementAttackProperties encAttackProp = null;
                    short containModeData = 0;
                    for (int k = 0; k < sigRefs.size(); ++k) {
                        EncryptedKeyElement encKey;
                        containModeData = ((ReferenceElement)sigRefs.get(j)).getReferencedElement().compareDocumentPosition(encDataList.get(i).getEncryptedElement());
                        if (0 != containModeData && 0 >= (0x10 & containModeData) && 0 >= (8 & containModeData)) continue;
                        KeyInfoElement keyInfo = null;
                        encAttackProp = encDataList.get(i).getAttackProperties();
                        encAttackProp.setSignedPart(((ReferenceElement)sigRefs.get(k)).getReferencedElement());
                        encAttackProp.setSignMode(containModeData);
                        keyInfo = encDataList.get(i).getKeyInfoElement();
                        if (null != keyInfo && null != (encKey = keyInfo.getEncryptedKeyElement())) {
                            encAttackProp = encKey.getAttackProperties();
                            encAttackProp.setSignMode(containModeData);
                            encAttackProp.setSignedPart(((ReferenceElement)sigRefs.get(k)).getReferencedElement());
                            LOG.info((Object)("EncryptedDataOnly with EncryptedKey in KeyInfo detected. Signed mode : " + containModeData));
                            continue;
                        }
                        LOG.info((Object)("EncryptedDataOnly detected with signed mode : " + containModeData));
                    }
                    continue;
                }
                throw new IllegalArgumentException("No valid EncryptionElement!");
            }
        }
    }

    private void detectSignedEncryptionKeyParts(List<SignatureElement> sigList) {
        List<EncryptedKeyElement> encKeyList = ((EncryptionInfo)this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.ENCRYPTIONFILTER)).getEncryptedKeyElements();
        for (int i = 0; i < encKeyList.size(); ++i) {
            for (int j = 0; j < sigList.size(); ++j) {
                if (encKeyList.get(i) instanceof EncryptedKeyElement) {
                    ElementAttackProperties encAttackProp = null;
                    List sigRefs = sigList.get(j).getReferences();
                    List<AbstractRefElement> encRefs = encKeyList.get(i).getReferenceElementList();
                    short containModeKey = 0;
                    for (int k = 0; k < sigRefs.size(); ++k) {
                        containModeKey = ((ReferenceElement)sigRefs.get(k)).getReferencedElement().compareDocumentPosition(encKeyList.get(i).getEncryptedElement());
                        if (0 == containModeKey || 0 < (0x10 & containModeKey) || 0 < (8 & containModeKey)) {
                            encAttackProp = encKeyList.get(i).getAttackProperties();
                            encAttackProp.setSignedPart(((ReferenceElement)sigRefs.get(k)).getReferencedElement());
                            encAttackProp.setSignMode(containModeKey);
                            LOG.info((Object)("Signed EncryptedKey detected with signed mode : " + containModeKey));
                        }
                        short containModeRefs = 0;
                        for (int l = 0; l < encRefs.size(); ++l) {
                            containModeRefs = ((ReferenceElement)sigRefs.get(k)).getReferencedElement().compareDocumentPosition(encRefs.get(l).getReferredElement());
                            if (0 != containModeRefs && 0 >= (0x10 & containModeRefs) && 0 >= (8 & containModeRefs)) continue;
                            if (encRefs.get(l) instanceof DataReferenceElement) {
                                encAttackProp = ((DataReferenceElement)encRefs.get(l)).getRefEncData().getAttackProperties();
                                encAttackProp.setSignedPart(((ReferenceElement)sigRefs.get(k)).getReferencedElement());
                                encAttackProp.setSignMode(containModeRefs);
                                LOG.info((Object)("Signed EncryptedData with EncKey detected with signed mode : " + containModeRefs));
                                continue;
                            }
                            if (!(encRefs.get(i) instanceof KeyReferenceElement)) continue;
                            throw new IllegalArgumentException(" keyreference not supported yet!");
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("No valid EncryptionElement!");
            }
        }
    }

    private void detectSignedTimeStamps() {
        List<SignatureElement> sigList = ((SignatureInfo)this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.SIGNATUREFILTER)).getSignatureElements();
        TimestampInfo timeStampInfo = (TimestampInfo)this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.TIMESTAMPFILTER);
        TimestampElement timestamp = timeStampInfo.getTimestamp();
        if (null != timestamp) {
            Element timestampElement = timestamp.getDetectionElement();
            for (int j = 0; j < sigList.size(); ++j) {
                List sigRefs = sigList.get(j).getReferences();
                short containModeStamp = 0;
                for (int k = 0; k < sigRefs.size(); ++k) {
                    containModeStamp = ((ReferenceElement)sigRefs.get(k)).getReferencedElement().compareDocumentPosition(timestampElement);
                    if (0 != containModeStamp && 0 >= (0x10 & containModeStamp) && 0 >= (8 & containModeStamp)) continue;
                    timestamp.setIsSigned(true);
                    LOG.info((Object)"Signed Timestamp detected.");
                    return;
                }
            }
            timestamp.setIsSigned(false);
            ((TimestampBase)timestamp).setTimeStampPayloads(timestamp.getDetectionElement());
            LOG.info((Object)"Detected Timestamp not signed.");
        }
    }
}

