/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness;

import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.AbstractEncryptionWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.EncryptedKeyRefWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.EncryptionAttributeIdWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.EncryptionAttributeTypeWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.EncryptionSchemaWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.WeaknessType;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;

public class FactoryWeakness {
    private FactoryWeakness() {
    }

    public static AbstractEncryptionWeakness generateWeakness(WeaknessType weaknessType, AbstractEncryptionElement encPay, EncryptedKeyElement encKey) throws InvalidWeaknessException {
        switch (weaknessType) {
            case SCHEMA_WEAKNESS: {
                return new EncryptionSchemaWeakness(encPay, encKey);
            }
            case ATTR_ID_WEAKNESS: {
                return new EncryptionAttributeIdWeakness(encPay, encKey);
            }
            case ENCKEY_REF_WEAKNESS: {
                return new EncryptedKeyRefWeakness(encPay, encKey);
            }
            case ATTR_TYPE_WEAKNESS: {
                return new EncryptionAttributeTypeWeakness(encPay);
            }
        }
        throw new IllegalArgumentException("No valid WeaknessType!");
    }
}

