/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness;

import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.AbstractWeaknessComposite;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;

public class EncryptionAttributeTypeWeakness
extends AbstractWeaknessComposite {
    private static final Logger LOG = Logger.getLogger(EncryptionAttributeTypeWeakness.class);

    public EncryptionAttributeTypeWeakness(AbstractEncryptionElement encPay) {
        this.m_EncPay = encPay;
        this.m_PossibleWeaks = null != this.m_EncPay.getType() ? 2 : 1;
    }

    @Override
    public int getPossibleNumWeaks() {
        return this.m_PossibleWeaks;
    }

    @Override
    public void abuseWeakness(int index, Element encKey, Element encPay) {
        switch (index %= this.m_PossibleWeaks) {
            case 0: {
                LOG.info((Object)("Hold Encryption Type of element " + encPay.getLocalName()));
                break;
            }
            case 1: {
                this.toggleEncryptionType(encPay);
                break;
            }
            default: {
                String error = "Index out of range: '" + index + "'";
                LOG.warn((Object)error);
            }
        }
    }

    private void toggleEncryptionType(Element encPay) {
        String encType = encPay.getAttributeNode("Type").getValue();
        if (encType.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            encPay.getAttributeNode("Type").setValue("http://www.w3.org/2001/04/xmlenc#Content");
        } else {
            encPay.getAttributeNode("Type").setValue("http://www.w3.org/2001/04/xmlenc#Element");
        }
        LOG.info((Object)("Encryption Type of element " + encPay.getLocalName() + " changed to " + encPay.getAttributeNode("Type").getValue()));
    }
}

