/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.oracle.base.mode.error;

import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import uk.ac.shef.wit.simmetrics.similaritymetrics.InterfaceStringMetric;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.mode.AbstractOracleBehaviour;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.mode.OracleResponseCollector;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;

public class OracleErrorBehaviour
extends AbstractOracleBehaviour {
    private final InterfaceStringMetric m_SimStringStrategy;
    private static final Logger LOG = Logger.getLogger(OracleErrorBehaviour.class);

    public OracleErrorBehaviour(OracleResponseCollector respTab, InterfaceStringMetric simStrategy) {
        this.m_ErrorResponseTab = respTab;
        this.m_SimStringStrategy = simStrategy;
        if (null == this.m_ErrorResponseTab) {
            throw new IllegalArgumentException("ErrorResponseTab not set");
        }
        if (null == this.m_SimStringStrategy) {
            throw new IllegalArgumentException("SimStringStrategy not set");
        }
    }

    @Override
    public OracleResponse compareServerRespWithUserClassification(OracleResponse resp, AbstractEncryptionElement pay) {
        OracleResponse respMaxScore = null;
        double maxScore = 0.0;
        double tempScore = 0.0;
        if (this.m_ErrorResponseTab.isIgnorePayloadResponse()) {
            try {
                if (this.m_ErrorResponseTab.checkIsRequestResponse(resp, pay)) {
                    resp.setResult(OracleResponse.Result.INVALID);
                    return resp;
                }
            }
            catch (XPathExpressionException | SAXException ex) {
                LOG.error((Object)ex);
            }
        }
        for (int i = 0; this.m_ErrorResponseTab.getData().size() > i; ++i) {
            tempScore = this.m_SimStringStrategy.getSimilarity(resp.getResponse(), this.m_ErrorResponseTab.getDataEntry(i).getResponse());
            if (!(tempScore > maxScore)) continue;
            respMaxScore = resp;
            respMaxScore.setResult(this.m_ErrorResponseTab.getDataEntry(i).getResult());
            maxScore = tempScore;
            if (maxScore >= this.m_ErrorResponseTab.getCompareThreshold()) break;
        }
        if (maxScore < this.m_ErrorResponseTab.getCompareThreshold()) {
            respMaxScore.setResult(OracleResponse.Result.UNDEFINED);
        }
        return respMaxScore;
    }
}

