/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.oracle.base;

import java.security.interfaces.RSAPublicKey;
import org.w3c.dom.Document;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.mode.AbstractOracleBehaviour;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.OracleRequest;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.TimestampInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.timestampelement.TimestampBase;
import wsattacker.library.xmlencryptionattack.timestampelement.TimestampElement;
import wsattacker.library.xmlencryptionattack.util.CryptoConstants;
import wsattacker.library.xmlencryptionattack.util.ServerSendCommandIF;

public abstract class AOracle {
    protected Document m_InputFile;
    protected Document m_AvoidedFile;
    protected AbstractEncryptionElement m_AttackPayload;
    protected ServerSendCommandIF m_ServerCommand;
    protected CryptoConstants.Algorithm m_AttackedAlgoritm;
    protected TimestampInfo m_TimestampInfo = null;
    protected AbstractOracleBehaviour m_OracleBehaviour;
    protected long numberOfQueries;
    protected RSAPublicKey m_PublicKey;

    public abstract OracleResponse[] sendRequests(OracleRequest[] var1);

    public abstract void setResponseValidity(OracleResponse var1, OracleResponse.Result var2);

    public abstract OracleResponse queryOracle(OracleRequest var1);

    public void resetNumberOfQueries() {
        this.numberOfQueries = 0L;
    }

    public long getNumberOfQueries() {
        return this.numberOfQueries;
    }

    public Document getInputFile() {
        return this.m_InputFile;
    }

    public void setInputFile(Document inputFile) {
        this.m_InputFile = inputFile;
    }

    public Document getAvoidedFile() {
        return this.m_AvoidedFile;
    }

    public void setAvoidedFile(Document avoidedFile) {
        this.m_AvoidedFile = avoidedFile;
    }

    public AbstractEncryptionElement getAttackPayload() {
        return this.m_AttackPayload;
    }

    public CryptoConstants.Algorithm getAttackedAlgoritm() {
        return this.m_AttackedAlgoritm;
    }

    public void setAttackedAlgoritm(CryptoConstants.Algorithm attackedAlgoritm) {
        this.m_AttackedAlgoritm = attackedAlgoritm;
    }

    public RSAPublicKey getPublicKey() {
        return this.m_PublicKey;
    }

    public void handleTimeStamp(Document attackDoc) throws InvalidPayloadException {
        TimestampElement timestamp;
        if (null != this.m_TimestampInfo && null != (timestamp = this.m_TimestampInfo.getTimestamp()) && null != timestamp.getDetectionPayElement()) {
            ((TimestampBase)timestamp).updateTimeStamp(attackDoc);
        }
    }

    public AbstractOracleBehaviour getOracleBehaviour() {
        return this.m_OracleBehaviour;
    }
}

