/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine;

import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import wsattacker.library.xmlencryptionattack.attackengine.AttackConfig;
import wsattacker.library.xmlencryptionattack.attackengine.CryptoAttackException;
import wsattacker.library.xmlencryptionattack.attackengine.attackbase.CCAAttack;
import wsattacker.library.xmlencryptionattack.attackengine.attackbase.XMLEncryptionAttackBase;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.CBCAttacker;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.pkcs1.BleichenbacherAttacker;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.AOracle;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.cbc.CBCOracle;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1.PKCS1Oracle;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AvoidedDocErrorInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.util.CryptoConstants;
import wsattacker.library.xmlencryptionattack.util.XMLEncryptionConstants;

public class AttackManager {
    private final DetectionReport m_DetectionReport;
    private final Document m_InputFile;
    private final Document m_AvoidedFile;
    private final AbstractEncryptionElement m_AttackPayload;
    private final CryptoConstants.Algorithm m_EncryptionMethod;
    private XMLEncryptionAttackBase m_XMLEncryptionAttack;

    public AttackManager(DetectionReport detectRep, AttackConfig attackCfg, AOracle oracle) throws CryptoAttackException {
        this.m_DetectionReport = detectRep;
        this.m_InputFile = this.m_DetectionReport.getRawFile();
        AvoidedDocErrorInfo wrapInfo = (AvoidedDocErrorInfo)detectRep.getDetectionInfo(DetectFilterEnum.AVOIDDOCFILTER);
        this.m_AttackPayload = wrapInfo.getOriginalPayInput();
        this.m_AvoidedFile = wrapInfo.getAvoidedDocument();
        if (null == this.m_AttackPayload) {
            throw new IllegalArgumentException("no attack payload set");
        }
        this.m_EncryptionMethod = CryptoConstants.getAlgorithm(this.m_AttackPayload.getEncryptionMethod());
        if (null == this.m_InputFile) {
            throw new IllegalArgumentException("input files not set");
        }
        this.initAttackObjects(attackCfg, oracle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initAttackObjects(AttackConfig attackCfg, AOracle oracle) throws IllegalArgumentException, CryptoAttackException {
        if (XMLEncryptionConstants.XMLEncryptionAttackMode.CBC_ATTACK == attackCfg.getXMLEncryptionAttack()) {
            if (!(this.m_AttackPayload instanceof EncryptedDataElement)) throw new IllegalArgumentException("cbc attack configured but no encdata payload");
            if (!(oracle instanceof CBCOracle)) throw new IllegalArgumentException("no cbc oracle configured");
            byte[] decodePay = Base64.decodeBase64((byte[])this.m_AttackPayload.getCipherDataChild().getEncryptedData().getBytes());
            if (null == this.m_EncryptionMethod) throw new IllegalArgumentException("payload has no encryption method");
            this.m_XMLEncryptionAttack = new CBCAttacker(decodePay, oracle, this.m_EncryptionMethod.BLOCK_SIZE);
            return;
        } else {
            if (!(this.m_AttackPayload instanceof EncryptedKeyElement)) throw new IllegalArgumentException("pkcs1 attack configured but no encKey payload");
            if (!(oracle instanceof PKCS1Oracle)) throw new IllegalArgumentException("no pkcs1 error oracle configured");
            byte[] decodePay = Base64.decodeBase64((byte[])this.m_AttackPayload.getCipherDataChild().getEncryptedData().getBytes());
            this.m_XMLEncryptionAttack = new BleichenbacherAttacker(decodePay, oracle);
        }
    }

    public DetectionReport getDetectionReport() {
        return this.m_DetectionReport;
    }

    public Document getInputFile() {
        return this.m_InputFile;
    }

    public Document getAvoidedFile() {
        return this.m_AvoidedFile;
    }

    public XMLEncryptionAttackBase getXMLEncryptionAttack() {
        return this.m_XMLEncryptionAttack;
    }

    public byte[] executeAttack() throws CryptoAttackException {
        return this.m_XMLEncryptionAttack.executeAttack();
    }

    public AOracle getOracleofCCAAttacker() {
        return ((CCAAttack)this.m_XMLEncryptionAttack).getOracle();
    }

    public CryptoConstants.Algorithm getEncryptionMethod() {
        return this.m_EncryptionMethod;
    }
}

