#!/usr/bin/python
import sys,os,time,subprocess,threading,readline,interfaces , logging
from colorama import Style , Fore
from wifi import Cell, Scheme

logging.getLogger("scapy.runtime").setLevel(logging.ERROR)
from scapy.all import *

#scan for APs
def scan(enc, interface):
	interfaces.disable_monitor_mode (interface)
	time.sleep(2)

	while True:
		ap_list = []
		print Style.DIM + '\n[+]Scanning for ' + enc + ' networks...\n' + Style.RESET_ALL
		print Fore.YELLOW + "\n#   BSSID\t\tChannel\t  Enc\tESSID" + Fore.RESET			

		for ap in Cell.all("wlan0"):
			encryption = "open" if ap.encrypted == False else ap.encryption_type
			if enc == "ALL":
				print str(len(ap_list)+1) + ". " + ap.address + "\t" + str(ap.channel) + "\t" + encryption + "\t" + ap.ssid
				ap_list.append(ap)
			elif ap.encrypted == True and (ap.encryption_type == enc or ap.encryption_type == enc + "2") :
				print str(len(ap_list)+1) + ". " + ap.address + "\t" + str(ap.channel) + "\t" + encryption + "\t" + ap.ssid
				ap_list.append(ap)
		
		return ap_list

def select_target(ap_list):
	while True:
		try:
			print "\nSelect target AP , enter 00 to scan again\n"
			target = input(Fore.BLUE + "Wi-fEye >> " + Fore.RESET)
			if target == 00:
				return False
			else:
				return ap_list[target-1]
				pass
		except (IndexError , NameError):
			print Fore.RED + "\n[-] Incorrect option"	 + Fore.RESET	
			continue
		break


#scan for hosts
def arp_scan(mode):
	while True:
		target_hosts = []
		target_ips = []
		
		try:
			print Style.DIM + "\n[+] Scanning for hosts ...\n" + Style.RESET_ALL
			alive,dead=srp(Ether(dst="ff:ff:ff:ff:ff:ff")/ARP(pdst='192.168.1.0/24'), timeout=2, verbose=0)
			print Fore.YELLOW + "#  MAC\t\t\tIP\t\tHost Name" + Fore.RESET
			for counter in range(0,len(alive)):		
				mac = alive[counter][1].hwsrc
				ip = alive[counter][1].psrc
				target_hosts.append(ip + " ")
				try:
					hostname = socket.gethostbyaddr(ip.replace("\n" , ""))[0].replace(".local" , "")
				except socket.herror:
					hostname = "Unknown"

				print str(counter+1) + ". " + mac + "\t" + ip + "\t" + hostname
				counter += counter
		except Exception:
			print Fore.RED + "[-] An error occured while scanning for hosts." + Fore.RESET
		if mode == 'prompt':
			while True:
				try: 
					print '''\nSelect targets or hit enter for ALL:
sepereate targets by a comma , ex: 1,2,4.\n
Enter 0 to scan again\n'''
					targets = raw_input(Fore.BLUE + "Wi-fEye >> " + Fore.RESET)
					if targets == "":
						return targets
					elif targets == '0':
						break
					else:
						targets = targets.split(",")
						for target_number in targets:
							target_ips.append(target_hosts[int(target_number) - 1])
						target_ips = "".join(target_ips).replace(" " , ";")[:-1]
						return target_ips
				except (IndexError , ValueError):
						print Fore.RED + "\n[-] Incorrect option"	 + Fore.RESET	
						continue
			continue
		else:
			break
