/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.server.commands;

import net.seleucus.wsp.server.WSServer;
import net.seleucus.wsp.server.commands.WSCommandOption;
import net.seleucus.wsp.util.WSUtil;

public class WSPassPhraseModify
extends WSCommandOption {
    public WSPassPhraseModify(WSServer myServer) {
        super(myServer);
    }

    @Override
    protected void execute() {
        String users = this.myServer.getWSDatabase().users.showUsers();
        this.myServer.println(users);
        int ppID = this.myServer.readLineOptionalInt("Select a User ID");
        boolean userIDFound = this.myServer.getWSDatabase().passPhrases.isPPIDInUse(ppID);
        if (!userIDFound) {
            this.myServer.println("User ID Not Found");
        } else {
            String userName = this.myServer.getWSDatabase().users.getUsersFullName(ppID);
            String choice = this.myServer.readLineOptional("Change pass-phrase [y/N]");
            if (WSUtil.isAnswerPositive(choice)) {
                CharSequence passSeq;
                boolean passPhraseInUse = true;
                do {
                    if (!(passPhraseInUse = this.myServer.getWSDatabase().passPhrases.isPassPhraseInUse(passSeq = this.myServer.readPasswordRequired("Enter the User's New Pass-Phrase")))) continue;
                    this.myServer.println("This Pass-Phrase is already taken and in use by another user");
                    this.myServer.println("WebSpa pass-phrases have to be unique for each user");
                } while (passPhraseInUse);
                boolean success = this.myServer.getWSDatabase().passPhrases.updatePassPhrase(ppID, passSeq);
                this.myServer.println("");
                this.myServer.println("ID: " + ppID);
                this.myServer.println("Full Name: " + userName);
                this.myServer.println("");
                if (success) {
                    this.myServer.println("Pass-Phrase Updated Successfully");
                } else {
                    this.myServer.println("Pass-Phrase Unchanged");
                }
                this.myServer.println("");
            }
        }
    }

    @Override
    public boolean handle(String cmd) {
        boolean validCommand = false;
        if (this.isValid(cmd)) {
            validCommand = true;
            this.execute();
        }
        return validCommand;
    }

    @Override
    protected boolean isValid(String cmd) {
        boolean valid = false;
        if (cmd.equalsIgnoreCase("pass-phrase modify") || cmd.equalsIgnoreCase("passwd")) {
            valid = true;
        }
        return valid;
    }
}

