/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.seleucus.wsp.config.WSConfiguration;
import net.seleucus.wsp.db.WSDatabase;
import net.seleucus.wsp.server.WSServer;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSLogListener
extends TailerListenerAdapter {
    static final Logger LOGGER = LoggerFactory.getLogger(WSLogListener.class);
    private WSServer myServer;
    private WSDatabase myDatabase;
    private WSConfiguration myConfiguration;

    public WSLogListener(WSServer myServer) {
        this.myServer = myServer;
        this.myDatabase = myServer.getWSDatabase();
        this.myConfiguration = myServer.getWSConfiguration();
    }

    @Override
    public void handle(String requestLine) {
        if (requestLine.length() > 65535) {
            return;
        }
        Pattern wsPattern = Pattern.compile(this.myConfiguration.getLoginRegexForEachRequest());
        Matcher wsMatcher = wsPattern.matcher(requestLine);
        if (!wsMatcher.matches() || 2 != wsMatcher.groupCount()) {
            LOGGER.info("Regex Problem?");
            LOGGER.info("Request line is {}.", (Object)requestLine);
            LOGGER.info("The regex is {}.", (Object)this.myConfiguration.getLoginRegexForEachRequest());
            return;
        }
        String ipAddress = wsMatcher.group(1);
        String webSpaRequest = wsMatcher.group(2);
        if (webSpaRequest.endsWith("/")) {
            webSpaRequest = webSpaRequest.substring(0, webSpaRequest.length() - 1);
        }
        if (webSpaRequest.length() == 100) {
            LOGGER.info("The 100 chars received are {}.", (Object)webSpaRequest);
            int ppID = this.myDatabase.passPhrases.getPPIDFromRequest(webSpaRequest);
            if (ppID < 0) {
                LOGGER.info("No User Found");
            } else {
                String username = this.myDatabase.users.getUsersFullName(ppID);
                LOGGER.info("User Found {}.", (Object)username);
                boolean userActive = this.myDatabase.passPhrases.getActivationStatus(ppID);
                LOGGER.info(this.myDatabase.passPhrases.getActivationStatusString(ppID));
                if (userActive) {
                    int action = this.myDatabase.actionsAvailable.getActionNumberFromRequest(ppID, webSpaRequest);
                    LOGGER.info("Action Number {}.", (Object)action);
                    if (action >= 0 && action <= 9) {
                        int aaID = this.myServer.getWSDatabase().actionsAvailable.getAAID(ppID, action);
                        this.myServer.getWSDatabase().actionsReceived.addAction(ipAddress, webSpaRequest, aaID);
                        String osCommand = this.myServer.getWSDatabase().actionsAvailable.getOSCommand(ppID, action);
                        LOGGER.info(ipAddress + " ->  '" + osCommand + "'");
                        this.myServer.runOSCommand(ppID, action, ipAddress);
                    }
                }
            }
        }
    }

    @Override
    public void handle(Exception arg0) {
    }

    @Override
    public void init(Tailer arg0) {
    }
}

