/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.db;

import java.nio.CharBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.seleucus.wsp.crypto.WebSpaEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSPassPhrases {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSPassPhrases.class);
    private Connection wsConnection;

    protected WSPassPhrases(Connection wsConnection) {
        this.wsConnection = wsConnection;
    }

    public synchronized boolean isPPIDInUse(int ppID) {
        boolean idExists = false;
        if (ppID > 0) {
            String sqlidLookup = "SELECT PPID FROM PASSPHRASES;";
            try {
                Statement stmt = this.wsConnection.createStatement();
                ResultSet rs = stmt.executeQuery(sqlidLookup);
                while (rs.next()) {
                    int dbPpID = rs.getInt(1);
                    if (dbPpID != ppID) continue;
                    idExists = true;
                    break;
                }
                rs.close();
                stmt.close();
            }
            catch (SQLException ex) {
                LOGGER.error("Is PPID in Use - A Database exception has occured: {}.", (Object)ex.getMessage());
            }
        }
        return idExists;
    }

    public synchronized boolean isPassPhraseInUse(CharSequence passSeq) {
        boolean passExists = false;
        String sqlPassPhrases = "SELECT PASSPHRASE FROM PASSPHRASES;";
        try {
            Statement stmt = this.wsConnection.createStatement();
            ResultSet rs = stmt.executeQuery(sqlPassPhrases);
            while (rs.next()) {
                char[] dbPassPhraseArray = rs.getString(1).toCharArray();
                CharBuffer dbPassSeq = CharBuffer.wrap(dbPassPhraseArray);
                if (!((Object)dbPassSeq).equals(passSeq)) continue;
                passExists = true;
                break;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Is Pass-Phrase in Use - A Database exception has occured: {}.", (Object)ex.getMessage());
        }
        return passExists;
    }

    public synchronized boolean getActivationStatus(int ppID) {
        boolean activationStatus = false;
        if (ppID > 0) {
            String sqlActivationLookup = "SELECT ACTIVE FROM PASSPHRASES WHERE PPID = ? ;";
            try {
                PreparedStatement psPassPhrase = this.wsConnection.prepareStatement(sqlActivationLookup);
                psPassPhrase.setInt(1, ppID);
                ResultSet rs = psPassPhrase.executeQuery();
                if (rs.next()) {
                    activationStatus = rs.getBoolean(1);
                }
                rs.close();
                psPassPhrase.close();
            }
            catch (SQLException ex) {
                LOGGER.error("Get Activation Status - A Database exception has occured: {}.", (Object)ex.getMessage());
            }
        }
        return activationStatus;
    }

    public synchronized String getActivationStatusString(int ppID) {
        StringBuilder outputStatusBuffer = new StringBuilder(127);
        outputStatusBuffer.append("User with ID: ");
        outputStatusBuffer.append(ppID);
        outputStatusBuffer.append(' ');
        String sqlActivationLookup = "SELECT ACTIVE FROM PASSPHRASES WHERE PPID = ? ;";
        try {
            PreparedStatement psPassPhrase = this.wsConnection.prepareStatement(sqlActivationLookup);
            psPassPhrase.setInt(1, ppID);
            ResultSet rs = psPassPhrase.executeQuery();
            if (rs.next()) {
                boolean activationStatus = rs.getBoolean(1);
                if (activationStatus) {
                    outputStatusBuffer.append("is active");
                } else {
                    outputStatusBuffer.append("is in-active");
                }
            } else {
                outputStatusBuffer.append("does not exist");
            }
            rs.close();
            psPassPhrase.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Get Activation Status String - A Database exception has occured: {}.", (Object)ex.getMessage());
        }
        return outputStatusBuffer.toString();
    }

    public synchronized boolean toggleUserActivation(int ppID) {
        boolean success = false;
        if (ppID > 0) {
            boolean currentActiveStatus = this.getActivationStatus(ppID);
            boolean oppositeActiveStatus = !currentActiveStatus;
            String sqlUpdate = "UPDATE PASSPHRASES SET ACTIVE = ? WHERE PPID = ? ;";
            try {
                PreparedStatement ps = this.wsConnection.prepareStatement(sqlUpdate);
                ps.setBoolean(1, oppositeActiveStatus);
                ps.setInt(2, ppID);
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                LOGGER.error("Toggle User Activation - A Database exception has occured: {}.", (Object)ex.getMessage());
            }
        }
        return success;
    }

    public synchronized int getPPIDFromRequest(String webSpaRequest) {
        int output = -1;
        String sqlPassPhrases = "SELECT PASSPHRASE, PPID FROM PASSPHRASES;";
        try {
            Statement stmt = this.wsConnection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT PASSPHRASE, PPID FROM PASSPHRASES;");
            while (rs.next()) {
                char[] dbPassPhraseArray = rs.getString(1).toCharArray();
                int dbPPID = rs.getInt(2);
                CharBuffer rawPassword = CharBuffer.wrap(dbPassPhraseArray);
                if (!WebSpaEncoder.matches(rawPassword, webSpaRequest)) continue;
                output = dbPPID;
                break;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Get PPID From Request - A Database exception has occured: {}.", (Object)ex.getMessage());
        }
        return output;
    }

    public synchronized CharSequence getPassPhrase(int ppID) {
        CharBuffer rawPassPhrase = CharBuffer.wrap("<could-not-find-pass-phrase>".toCharArray());
        if (ppID > 0) {
            String sqlPassPhraseLookup = "SELECT PASSPHRASE FROM PASSPHRASES WHERE PPID = ? ;";
            try {
                PreparedStatement psPassPhrase = this.wsConnection.prepareStatement("SELECT PASSPHRASE FROM PASSPHRASES WHERE PPID = ? ;");
                psPassPhrase.setInt(1, ppID);
                ResultSet rs = psPassPhrase.executeQuery();
                if (rs.next()) {
                    char[] dbPassPhraseArray = rs.getString(1).toCharArray();
                    rawPassPhrase = CharBuffer.wrap(dbPassPhraseArray);
                }
                rs.close();
                psPassPhrase.close();
            }
            catch (SQLException ex) {
                LOGGER.error("Get Pass-Phrase - A Database exception has occured: {}.", (Object)ex.getMessage());
            }
        }
        return rawPassPhrase;
    }

    public synchronized String getLastModifiedDate(int ppID) {
        String lastModified = "0000-00-00 00:00:00.000";
        if (ppID > 0) {
            String sqlModifiedLookup = "SELECT MODIFIED FROM PASSPHRASES WHERE PPID = ? ;";
            try {
                PreparedStatement psModified = this.wsConnection.prepareStatement("SELECT MODIFIED FROM PASSPHRASES WHERE PPID = ? ;");
                psModified.setInt(1, ppID);
                ResultSet rs = psModified.executeQuery();
                if (rs.next()) {
                    lastModified = rs.getString(1).substring(0, 23);
                }
                rs.close();
                psModified.close();
            }
            catch (SQLException ex) {
                LOGGER.error("Get Last Modified Date - A Database exception has occured: {}.", (Object)ex.getMessage());
            }
        }
        return lastModified;
    }

    public synchronized boolean updatePassPhrase(int ppID, CharSequence passSeq) {
        boolean success = false;
        if (ppID > 0) {
            String passPhraseUpdate = "UPDATE PASSPHRASES SET PASSPHRASE = ? , MODIFIED = CURRENT_TIMESTAMP WHERE PPID = ? ;";
            try {
                PreparedStatement ps = this.wsConnection.prepareStatement("UPDATE PASSPHRASES SET PASSPHRASE = ? , MODIFIED = CURRENT_TIMESTAMP WHERE PPID = ? ;");
                ps.setString(1, passSeq.toString());
                ps.setInt(2, ppID);
                int rowCount = ps.executeUpdate();
                if (rowCount == 1) {
                    success = true;
                }
            }
            catch (SQLException ex) {
                LOGGER.error("Update Pass-Phrase - A Database exception has occured: {}.", (Object)ex.getMessage());
            }
        }
        return success;
    }
}

