/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.db;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import net.seleucus.wsp.db.WSActionsAvailable;
import net.seleucus.wsp.db.WSActionsReceived;
import net.seleucus.wsp.db.WSPassPhrases;
import net.seleucus.wsp.db.WSUsers;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSDatabase.class);
    protected static final String DB_PATH = "webspa-db";
    private Connection wsConnection;
    public WSActionsAvailable actionsAvailable;
    public WSActionsReceived actionsReceived;
    public WSPassPhrases passPhrases;
    public WSUsers users;

    public WSDatabase() throws ClassNotFoundException, SQLException, IOException {
        File propsFile = new File("webspa-db.properties");
        if (!propsFile.exists()) {
            LOGGER.debug("Database properties file {} not found.", (Object)propsFile.getName());
            URL bundledPropsLocation = ClassLoader.getSystemResource("data/bundled-webspa-db.properties");
            LOGGER.debug("Copying default database properties file from bundle");
            FileUtils.copyURLToFile(bundledPropsLocation, propsFile);
        } else {
            LOGGER.debug("Database properties file {} found in current directory.", (Object)propsFile.getName());
        }
        File scriptFile = new File("webspa-db.script");
        if (!scriptFile.exists()) {
            LOGGER.debug("Database script file {} not found.", (Object)scriptFile.getName());
            URL bundledScriptlocation = ClassLoader.getSystemResource("data/bundled-webspa-db.script");
            LOGGER.debug("Copying default database script file from bundle");
            FileUtils.copyURLToFile(bundledScriptlocation, scriptFile);
        } else {
            LOGGER.debug("Database script file {} found in current directory.", (Object)scriptFile.getName());
        }
        LOGGER.debug("Establishing the database connection to: {}", (Object)DB_PATH);
        Class.forName("org.hsqldb.jdbcDriver");
        this.wsConnection = DriverManager.getConnection("jdbc:hsqldb:webspa-db");
        this.actionsAvailable = new WSActionsAvailable(this.wsConnection);
        this.actionsReceived = new WSActionsReceived(this.wsConnection);
        this.passPhrases = new WSPassPhrases(this.wsConnection);
        this.users = new WSUsers(this.wsConnection);
    }

    public synchronized void shutdown() {
        try {
            Statement st = this.wsConnection.createStatement();
            LOGGER.info("Beginning database shutdown...");
            st.execute("SHUTDOWN");
            this.wsConnection.close();
            LOGGER.info("Database shutdown complete.");
        }
        catch (SQLException ex) {
            LOGGER.error("A Database exception has occured: {}.", (Object)ex.getMessage());
        }
    }
}

