/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.db;

import java.nio.CharBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.seleucus.wsp.crypto.WebSpaEncoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSActionsAvailable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSActionsAvailable.class);
    private Connection wsConnection;

    protected WSActionsAvailable(Connection wsConnection) {
        this.wsConnection = wsConnection;
    }

    public synchronized void addAction(int ppID, String osCommand, int action) {
        String sqlInsert = "INSERT INTO PUBLIC.ACTIONS_AVAILABLE (PPID, ACTION_NUMBER, COMMAND) VALUES (?, ?, ?); ";
        try {
            PreparedStatement preStatement = this.wsConnection.prepareStatement("INSERT INTO PUBLIC.ACTIONS_AVAILABLE (PPID, ACTION_NUMBER, COMMAND) VALUES (?, ?, ?); ");
            preStatement.setInt(1, ppID);
            preStatement.setInt(2, action);
            preStatement.setString(3, osCommand);
            preStatement.executeUpdate();
            preStatement.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Add Add Action - A Database exception has occured: {}.", (Object)ex.getMessage());
        }
    }

    public synchronized int getActionNumberFromRequest(int ppID, String webSpaRequest) {
        int actionNumber = -1;
        if (ppID > 0) {
            String sqlActivationLookup = "SELECT PASSPHRASE FROM PASSPHRASES WHERE PPID = ? ;";
            try {
                PreparedStatement psPassPhrase = this.wsConnection.prepareStatement(sqlActivationLookup);
                psPassPhrase.setInt(1, ppID);
                ResultSet rs = psPassPhrase.executeQuery();
                if (rs.next()) {
                    char[] dbPassPhraseArray = rs.getString(1).toCharArray();
                    CharBuffer rawPassword = CharBuffer.wrap(dbPassPhraseArray);
                    actionNumber = WebSpaEncoder.getActionNumber(rawPassword, webSpaRequest);
                }
                rs.close();
                psPassPhrase.close();
            }
            catch (SQLException ex) {
                LOGGER.error("Get Action Number from Request - A Database exception has occured: {}.", (Object)ex.getMessage());
            }
        }
        return actionNumber;
    }

    public String getOSCommand(int ppID, int actionNumber) {
        String command = "";
        String sqlSelect = "SELECT COMMAND FROM ACTIONS_AVAILABLE WHERE PPID = ? AND ACTION_NUMBER = ? ;";
        try {
            PreparedStatement psPassPhrase = this.wsConnection.prepareStatement("SELECT COMMAND FROM ACTIONS_AVAILABLE WHERE PPID = ? AND ACTION_NUMBER = ? ;");
            psPassPhrase.setInt(1, ppID);
            psPassPhrase.setInt(2, actionNumber);
            ResultSet rs = psPassPhrase.executeQuery();
            if (rs.next()) {
                command = rs.getString(1);
            }
            rs.close();
            psPassPhrase.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Get O/S Command - A Database exception has occured: {}.", (Object)ex.getMessage());
        }
        return command;
    }

    public int getAAID(int ppID, int actionNumber) {
        int output = -1;
        String sqlSelect = "SELECT AAID FROM ACTIONS_AVAILABLE WHERE PPID = ? AND ACTION_NUMBER = ? ;";
        try {
            PreparedStatement psStatement = this.wsConnection.prepareStatement("SELECT AAID FROM ACTIONS_AVAILABLE WHERE PPID = ? AND ACTION_NUMBER = ? ;");
            psStatement.setInt(1, ppID);
            psStatement.setInt(2, actionNumber);
            ResultSet rs = psStatement.executeQuery();
            if (rs.next()) {
                output = rs.getInt(1);
            }
            rs.close();
            psStatement.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Get AAID - A Database exception has occured: {}.", (Object)ex.getMessage());
        }
        return output;
    }

    public synchronized boolean isActionNumberInUse(int ppID, int action) {
        boolean actionNumberInUse = false;
        if (this.isPPIDInUse(ppID)) {
            String sqlSelect = "SELECT ACTION_NUMBER FROM ACTIONS_AVAILABLE WHERE PPID = ? ;";
            try {
                PreparedStatement stmt = this.wsConnection.prepareStatement("SELECT ACTION_NUMBER FROM ACTIONS_AVAILABLE WHERE PPID = ? ;");
                stmt.setInt(1, ppID);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    int dbAction = rs.getInt(1);
                    if (dbAction != action) continue;
                    actionNumberInUse = true;
                    break;
                }
                rs.close();
                stmt.close();
            }
            catch (SQLException ex) {
                LOGGER.error("Is Action Number in Use - A Database exception has occured: {}.", (Object)ex.getMessage());
            }
        }
        return actionNumberInUse;
    }

    private synchronized boolean isPPIDInUse(int ppID) {
        boolean idExists = false;
        if (ppID > 0) {
            String sqlidLookup = "SELECT PPID FROM PASSPHRASES;";
            try {
                Statement stmt = this.wsConnection.createStatement();
                ResultSet rs = stmt.executeQuery(sqlidLookup);
                while (rs.next()) {
                    int dbPpID = rs.getInt(1);
                    if (dbPpID != ppID) continue;
                    idExists = true;
                    break;
                }
                rs.close();
                stmt.close();
            }
            catch (SQLException ex) {
                LOGGER.error("Is PPID Number in Use - A Database exception has occured: {}.", (Object)ex.getMessage());
            }
        }
        return idExists;
    }

    public synchronized String showActionDetails(int ppID, int actionNumber) {
        StringBuffer resultsBuffer = new StringBuffer();
        resultsBuffer.append('\n');
        resultsBuffer.append("Action with Number: ");
        resultsBuffer.append(actionNumber);
        resultsBuffer.append('\n');
        String sqlSelect = "SELECT COMMAND, LAST_EXECUTED, LAST_RUN_SUCCESS, IP_ADDR FROM ACTIONS_AVAILABLE WHERE PPID = ? AND ACTION_NUMBER = ? ;";
        try {
            PreparedStatement ps = this.wsConnection.prepareStatement("SELECT COMMAND, LAST_EXECUTED, LAST_RUN_SUCCESS, IP_ADDR FROM ACTIONS_AVAILABLE WHERE PPID = ? AND ACTION_NUMBER = ? ;");
            ps.setInt(1, ppID);
            ps.setInt(2, actionNumber);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                resultsBuffer.append("Belongs to User: ");
                resultsBuffer.append(ppID);
                resultsBuffer.append('\n');
                resultsBuffer.append("Represents the O/S Command: ");
                resultsBuffer.append(rs.getString(1));
                resultsBuffer.append('\n');
                resultsBuffer.append('\n');
                String lastExecuted = rs.getString(2);
                if (lastExecuted == null) {
                    resultsBuffer.append("Has Never Been Executed");
                } else {
                    resultsBuffer.append("Was last Executed On: ");
                    resultsBuffer.append(lastExecuted.substring(0, 23));
                }
                resultsBuffer.append('\n');
                String lastSuccess = rs.getString(3);
                resultsBuffer.append("The last Execution was Successful: ");
                if (lastSuccess == null) {
                    resultsBuffer.append("n/a");
                } else {
                    resultsBuffer.append(lastSuccess);
                }
                resultsBuffer.append('\n');
                String remoteLocation = rs.getString(4);
                resultsBuffer.append("It was Received from the Remote Location: ");
                if (remoteLocation == null) {
                    resultsBuffer.append("n/a");
                } else {
                    resultsBuffer.append(remoteLocation);
                }
            } else {
                resultsBuffer.append("Cannot Be Found!");
            }
            resultsBuffer.append('\n');
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Show Action Details - A Database exception has occured: {}.", (Object)ex.getMessage());
        }
        return resultsBuffer.toString();
    }

    public synchronized String showActions(int ppID) {
        StringBuffer resultsBuffer = new StringBuffer();
        resultsBuffer.append('\n');
        resultsBuffer.append("Actions for user with ID: ");
        resultsBuffer.append(ppID);
        resultsBuffer.append('\n');
        resultsBuffer.append("___________________________________________________________");
        resultsBuffer.append('\n');
        resultsBuffer.append(" #  ");
        resultsBuffer.append(StringUtils.rightPad("O/S Command", 32));
        resultsBuffer.append(StringUtils.rightPad("Last Executed", 25));
        resultsBuffer.append('\n');
        resultsBuffer.append("-----------------------------------------------------------");
        resultsBuffer.append('\n');
        String sqlSelect = "SELECT ACTION_NUMBER, COMMAND, LAST_EXECUTED FROM ACTIONS_AVAILABLE WHERE PPID = ? ;";
        try {
            PreparedStatement ps = this.wsConnection.prepareStatement("SELECT ACTION_NUMBER, COMMAND, LAST_EXECUTED FROM ACTIONS_AVAILABLE WHERE PPID = ? ;");
            ps.setInt(1, ppID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                resultsBuffer.append(' ');
                resultsBuffer.append(StringUtils.rightPad(rs.getString(1), 3));
                resultsBuffer.append(StringUtils.rightPad(StringUtils.abbreviate(rs.getString(2), 30), 32));
                String lastExecuted = rs.getString(3);
                if (lastExecuted != null) {
                    resultsBuffer.append(lastExecuted.substring(0, 23));
                } else {
                    resultsBuffer.append("has never been executed");
                }
                resultsBuffer.append('\n');
            }
            resultsBuffer.append("___________________________________________________________");
            resultsBuffer.append('\n');
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Show Actions - A Database exception has occured: {}.", (Object)ex.getMessage());
        }
        return resultsBuffer.toString();
    }

    public synchronized void updateAction(int ppID, int action, boolean success, String ipAddress) {
        String sqlUpdate = "UPDATE PUBLIC.ACTIONS_AVAILABLE SET LAST_EXECUTED = CURRENT_TIMESTAMP, LAST_RUN_SUCCESS = ?, IP_ADDR = ? WHERE PPID = ? AND ACTION_NUMBER = ? ;";
        try {
            PreparedStatement psPassPhrase = this.wsConnection.prepareStatement("UPDATE PUBLIC.ACTIONS_AVAILABLE SET LAST_EXECUTED = CURRENT_TIMESTAMP, LAST_RUN_SUCCESS = ?, IP_ADDR = ? WHERE PPID = ? AND ACTION_NUMBER = ? ;");
            psPassPhrase.setBoolean(1, success);
            psPassPhrase.setString(2, ipAddress);
            psPassPhrase.setInt(3, ppID);
            psPassPhrase.setInt(4, action);
            psPassPhrase.executeUpdate();
            psPassPhrase.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Update Action - A Database exception has occured: {}.", (Object)ex.getMessage());
        }
    }
}

