/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.crypto;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import net.seleucus.wsp.crypto.WebSpaUtils;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.ArrayUtils;

public final class PassPhraseCrypto
extends WebSpaUtils {
    protected static byte[] getHashedPassPhraseInTimeWithSalt(CharSequence passPhrase, long currentTimeMinutes, byte salt) {
        byte[] passBytes = passPhrase.toString().getBytes(Charsets.UTF_8);
        byte[] timeBytes = ByteBuffer.allocate(8).putLong(currentTimeMinutes).array();
        byte[] sortedBytes = new byte[passBytes.length + timeBytes.length - 4];
        System.arraycopy(passBytes, 0, sortedBytes, 0, passBytes.length);
        System.arraycopy(timeBytes, 4, sortedBytes, passBytes.length, timeBytes.length - 4);
        byte[] randomBytes = new byte[]{salt};
        byte[] allBytes = ArrayUtils.addAll(sortedBytes, randomBytes);
        byte[] hashedBytes = ArrayUtils.subarray(PassPhraseCrypto.digest(allBytes), 0, 50);
        return ArrayUtils.addAll(randomBytes, hashedBytes);
    }

    protected static byte[] getHashedPassPhraseNowWithSalt(CharSequence passPhrase, byte salt) {
        long currentTimeMinutes = System.currentTimeMillis() / 60000L;
        return PassPhraseCrypto.getHashedPassPhraseInTimeWithSalt(passPhrase, currentTimeMinutes, salt);
    }

    protected static byte[] getHashedPassPhraseInTime(CharSequence passPhrase, long currentTimeMinutes) {
        SecureRandom scRandom = new SecureRandom();
        byte[] randomBytes = new byte[1];
        scRandom.nextBytes(randomBytes);
        return PassPhraseCrypto.getHashedPassPhraseInTimeWithSalt(passPhrase, currentTimeMinutes, randomBytes[0]);
    }

    protected static byte[] getHashedPassPhraseNow(CharSequence passPhrase) {
        long currentTimeMinutes = System.currentTimeMillis() / 60000L;
        SecureRandom scRandom = new SecureRandom();
        byte[] randomBytes = new byte[1];
        scRandom.nextBytes(randomBytes);
        return PassPhraseCrypto.getHashedPassPhraseInTimeWithSalt(passPhrase, currentTimeMinutes, randomBytes[0]);
    }

    private PassPhraseCrypto() {
        throw new UnsupportedOperationException();
    }
}

