/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.analysis.urls;

import com.subgraph.vega.api.html.IHTMLParseResult;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.util.VegaURI;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public class HtmlUrlExtractor {
    List<VegaURI> findHtmlUrls(IHttpResponse iHttpResponse) {
        VegaURI vegaURI;
        IHTMLParseResult iHTMLParseResult = iHttpResponse.getParsedHTML();
        ArrayList<VegaURI> arrayList = new ArrayList<VegaURI>();
        if (iHTMLParseResult != null) {
            arrayList.addAll(this.extractUrlsFromDocument(iHttpResponse, iHTMLParseResult.getJsoupDocument(), iHttpResponse.getBodyAsString()));
        }
        if (iHttpResponse.getRawResponse().containsHeader("Location") && (vegaURI = this.locationExtractor(iHttpResponse, iHttpResponse.getRawResponse().getFirstHeader("Location").getValue())) != null) {
            arrayList.add(vegaURI);
        }
        return arrayList;
    }

    List<VegaURI> findHtmlUrls(IHttpResponse iHttpResponse, HttpEntity httpEntity, URI uRI) throws IOException {
        String string = this.inputStreamToString(httpEntity.getContent());
        Document document = Jsoup.parse((String)string, (String)uRI.toString());
        return this.extractUrlsFromDocument(iHttpResponse, document, string);
    }

    private List<VegaURI> extractUrlsFromDocument(IHttpResponse iHttpResponse, Document document, String string) {
        ArrayList<VegaURI> arrayList = new ArrayList<VegaURI>();
        arrayList.addAll(this.extractURIs(iHttpResponse, document, "a[href]", "abs:href"));
        arrayList.addAll(this.extractURIs(iHttpResponse, document, "[src]", "abs:src"));
        arrayList.addAll(this.extractURIs(iHttpResponse, document, "link[href]", "abs:href"));
        arrayList.addAll(this.extractURIs(iHttpResponse, document, "meta", ""));
        arrayList.addAll(this.responseBodyUriScanFast(iHttpResponse, document, string));
        return arrayList;
    }

    private String inputStreamToString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[8192];
        int n;
        while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        return stringWriter.toString();
    }

    private List<VegaURI> extractURIs(IHttpResponse iHttpResponse, Document document, String string, String string2) {
        ArrayList<VegaURI> arrayList = new ArrayList<VegaURI>();
        for (Element element : document.select(string)) {
            HttpHost httpHost;
            URI uRI;
            Object object;
            Object object2;
            if (element.tagName().equals("meta") && element.attr("http-equiv").toLowerCase().equals("refresh")) {
                object2 = this.extractMetaRefresh(document, element);
                object = !((String)object2).startsWith("http://") && !((String)object2).startsWith("https://") ? this.absUri(iHttpResponse, document.baseUri(), (String)object2) : object2;
                uRI = this.createURI((String)object);
                if (uRI == null || !this.hasValidHttpScheme(uRI) || !this.validateHost(httpHost = URIUtils.extractHost((URI)uRI))) continue;
                VegaURI vegaURI = new VegaURI(httpHost, uRI.normalize().getPath(), uRI.getQuery());
                arrayList.add(vegaURI);
                continue;
            }
            object = element.attr(string2);
            object2 = this.createURI((String)(object = ((String)object).replace("\\", "%5C")));
            if (object2 == null || !this.hasValidHttpScheme((URI)object2) || !this.validateHost((HttpHost)(uRI = URIUtils.extractHost((URI)object2)))) continue;
            httpHost = new VegaURI((HttpHost)uRI, ((URI)object2).normalize().getPath(), ((URI)object2).getQuery());
            arrayList.add((VegaURI)httpHost);
        }
        return arrayList;
    }

    private boolean validateHost(HttpHost httpHost) {
        if (httpHost.getHostName() == null || httpHost.getHostName().isEmpty()) {
            return false;
        }
        try {
            new URI(httpHost.getSchemeName(), null, httpHost.getHostName(), httpHost.getPort(), null, null, null);
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    private boolean hasValidHttpScheme(URI uRI) {
        String string = uRI.getScheme();
        return string != null && (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https"));
    }

    private URI createURI(String string) {
        block3: {
            try {
                if (!string.isEmpty()) break block3;
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return new URI(Parser.unescapeEntities((String)string, (boolean)false));
    }

    private String extractMetaRefresh(Document document, Element element) {
        String string = element.attr("content");
        String string2 = string.replaceAll("\\s", "");
        if (string2.toLowerCase().contains("url=")) {
            return string2.split("=")[1];
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String absUri(IHttpResponse iHttpResponse, String string, String string2) {
        String string3 = string;
        URI uRI = null;
        boolean bl = false;
        int n = 0;
        int n2 = -1;
        if (string2.startsWith("/")) {
            return String.valueOf(iHttpResponse.getRequestUri().getScheme()) + "://" + iHttpResponse.getRequestUri().getHost() + string2;
        }
        if (string.startsWith("http://") || string.startsWith("https://")) {
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            if (uRI == null) return "";
            string3 = uRI.getPath();
        }
        while (n < string3.length() && !bl) {
            if (string3.startsWith(".php", n) || string3.startsWith(".html", n) || string3.startsWith(".asp", n) || string3.startsWith(".jsp", n)) {
                bl = true;
            } else if (string3.charAt(n) == '/' || string3.charAt(n) == '\\') {
                n2 = n;
            }
            ++n;
        }
        if (bl) {
            if (n2 < 0) return String.valueOf(iHttpResponse.getRequestUri().getScheme()) + "://" + iHttpResponse.getRequestUri().getHost() + "/" + string3 + "/" + string2;
            return String.valueOf(iHttpResponse.getRequestUri().getScheme()) + "://" + iHttpResponse.getRequestUri().getHost() + "/" + string3.substring(0, n2) + "/" + string2;
        }
        if (n2 < 0) return String.valueOf(iHttpResponse.getRequestUri().getScheme()) + "://" + iHttpResponse.getRequestUri().getHost() + string3 + "/" + string2;
        return String.valueOf(iHttpResponse.getRequestUri().getScheme()) + "://" + iHttpResponse.getRequestUri().getHost() + string3.substring(0, n2) + "/" + string2;
    }

    private ArrayList<VegaURI> responseBodyUriScanFast(IHttpResponse iHttpResponse, Document document, String string) {
        ArrayList<VegaURI> arrayList = new ArrayList<VegaURI>();
        int n = 0;
        String string2 = string.toLowerCase();
        while (n < string.length()) {
            URI uRI;
            Object object;
            int n2;
            if (string2.startsWith("http://", n) || string2.startsWith("https://", n)) {
                int n3;
                if (string2.startsWith("http://", n) ? n + 7 >= string.length() : string2.startsWith("https://", n) && n + 8 >= string.length()) {
                    return arrayList;
                }
                n2 = n3 = n;
                Boolean bl = false;
                while (n2 < string.length() && !bl.booleanValue()) {
                    if (Character.isWhitespace(string.charAt(n2)) || string.charAt(n2) == '\"' || string.charAt(n2) == '\'' || string.charAt(n2) == '>' || string.charAt(n2) == '<' || string.charAt(n2) == ')') {
                        String string3 = string.substring(n3, n2);
                        URI uRI2 = this.createURI(string3);
                        if (uRI2 != null && this.hasValidHttpScheme(uRI2) && this.validateHost((HttpHost)(object = URIUtils.extractHost((URI)uRI2)))) {
                            uRI = new VegaURI((HttpHost)object, uRI2.normalize().getPath(), uRI2.getQuery());
                            arrayList.add((VegaURI)uRI);
                        }
                        n = n2 + 1;
                        bl = true;
                        continue;
                    }
                    ++n2;
                }
            } else if (string2.startsWith(".php", n) || string2.startsWith(".asp", n) || string2.startsWith(".jsp", n) || string2.startsWith(".html", n)) {
                Boolean bl = false;
                int n4 = n2 = n;
                int n5 = 0;
                int n6 = string.length();
                while (n4 >= 0 && !bl.booleanValue()) {
                    if (Character.isWhitespace(string.charAt(n4)) || string.charAt(n4) == '(' || string.charAt(n4) == '\"' || string.charAt(n4) == '\'' || string.charAt(n4) == '>' || string.charAt(n4) == '<' || string.charAt(n4) == ')') {
                        n5 = n4 + 1;
                        bl = true;
                        continue;
                    }
                    --n4;
                }
                n4 = n5;
                bl = false;
                while (n4 < string.length() && !bl.booleanValue()) {
                    if (Character.isWhitespace(string.charAt(n4)) || string.charAt(n4) == '\"' || string.charAt(n4) == '\'' || string.charAt(n4) == '>' || string.charAt(n4) == '<' || string.charAt(n4) == ')') {
                        HttpHost httpHost;
                        n6 = n4;
                        bl = true;
                        object = string.substring(n5, n6);
                        if (!((String)object).startsWith("http://") && !((String)object).startsWith("https://")) {
                            object = this.absUri(iHttpResponse, document.baseUri(), (String)object);
                        }
                        if ((uRI = this.createURI((String)object)) != null && this.hasValidHttpScheme(uRI) && this.validateHost(httpHost = URIUtils.extractHost((URI)uRI))) {
                            VegaURI vegaURI = new VegaURI(httpHost, uRI.normalize().getPath(), uRI.getQuery());
                            arrayList.add(vegaURI);
                        }
                        n = n4 + 1;
                        continue;
                    }
                    ++n4;
                }
            }
            ++n;
        }
        return arrayList;
    }

    private VegaURI locationExtractor(IHttpResponse iHttpResponse, String string) {
        HttpHost httpHost;
        String string2 = !string.startsWith("http://") && !string.startsWith("https://") ? this.absUri(iHttpResponse, iHttpResponse.getRequestUri().toString(), string) : string;
        URI uRI = this.createURI(string2);
        if (uRI != null && this.hasValidHttpScheme(uRI) && this.validateHost(httpHost = URIUtils.extractHost((URI)uRI))) {
            return new VegaURI(httpHost, uRI.normalize().getPath(), uRI.getQuery());
        }
        return null;
    }
}

