/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.analysis;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.analysis.IContentAnalyzerFactory;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.internal.analysis.ContentAnalyzer;

public class ContentAnalyzerFactory
implements IContentAnalyzerFactory {
    private final IEventHandler workspaceEventHandler = this.createWorkspaceEventHandler();
    private IModel model;
    private IWorkspace currentWorkspace;

    public IContentAnalyzer createContentAnalyzer(IScanInstance iScanInstance) {
        return new ContentAnalyzer(this, iScanInstance);
    }

    private IEventHandler createWorkspaceEventHandler() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    ContentAnalyzerFactory.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    ContentAnalyzerFactory.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    ContentAnalyzerFactory.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        };
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.currentWorkspace = workspaceOpenEvent.getWorkspace();
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.currentWorkspace = null;
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.currentWorkspace = workspaceResetEvent.getWorkspace();
    }

    IWorkspace getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    void activate() {
        this.currentWorkspace = this.model.addWorkspaceListener(this.workspaceEventHandler);
    }

    void deactivate() {
        this.model.removeWorkspaceListener(this.workspaceEventHandler);
        this.currentWorkspace = null;
    }

    protected void setModel(IModel iModel) {
        this.model = iModel;
    }

    protected void unsetModel(IModel iModel) {
        this.model = null;
    }
}

