/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.analysis;

import com.subgraph.vega.api.http.requests.IHttpResponse;

public class CSSDetector {
    boolean isBodyCSS(IHttpResponse iHttpResponse) {
        if (!iHttpResponse.isMostlyAscii()) {
            return false;
        }
        String string = iHttpResponse.getBodyAsString();
        if (string == null || string.isEmpty()) {
            return false;
        }
        int n = 0;
        char c = '\u0000';
        boolean bl = false;
        while (n < string.length()) {
            n = this.skipWhitespace(string, n);
            if ((n = this.skipComments(string, n)) >= string.length()) break;
            if (this.isCSSKeyword(string, n)) {
                return true;
            }
            char c2 = string.charAt(n);
            if (c2 == '{') {
                return bl && c != '\u0000' && (Character.isLetterOrDigit(c) || "-_]*".indexOf(c) != -1);
            }
            if (bl) {
                if (!Character.isLetterOrDigit(c2) && ":,.#_-*[]~=\"'>".indexOf(c2) == -1) {
                    return false;
                }
            } else {
                if (!Character.isLetterOrDigit(c2) && ".#_-*".indexOf(c2) == -1) {
                    return false;
                }
                bl = true;
            }
            c = c2;
            ++n;
        }
        return false;
    }

    private int skipWhitespace(String string, int n) {
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private int skipComments(String string, int n) {
        while (n < string.length()) {
            int n2;
            if (string.startsWith("<!--", n)) {
                n += 4;
                continue;
            }
            if (string.startsWith("//")) {
                n2 = string.indexOf("\r\n", 2);
                n = n2 == -1 ? string.length() : n + n2 + 2;
                continue;
            }
            if (string.startsWith("/*")) {
                n2 = string.indexOf("*/");
                n = n2 == -1 ? string.length() : n + n2 + 2;
                continue;
            }
            return n;
        }
        return n;
    }

    private boolean isCSSKeyword(String string, int n) {
        if (n + 1 < string.length() && string.charAt(n) == '@') {
            int n2 = n + 8 > string.length() ? string.length() : n + 8;
            String string2 = string.substring(n + 1, n2).toLowerCase();
            return string2.startsWith("import") || string2.startsWith("media") || string2.startsWith("charset");
        }
        return false;
    }
}

