/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.wizards;

import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.model.scope.ITargetScopeManager;
import com.subgraph.vega.api.model.web.IWebModelVisitor;
import com.subgraph.vega.api.util.UriTools;
import com.subgraph.vega.ui.scanner.scope.EditScopeDialog;
import com.subgraph.vega.ui.scanner.wizards.InScopeWebVisitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewScanTargetPage
extends WizardPage {
    private static final String TARGET_TITLE = "Select a Scan Target";
    private static final String TARGET_DESCRIPTION = "Choose a target for new scan";
    private final IWorkspace workspace;
    private final String targetUriText;
    private Text scanTargetUriText;
    private ComboViewer scopeComboViewer;
    private ListViewer scopeURIViewer;
    private Button includeModelContent;
    private ITargetScope comboScope;
    private ITargetScope uriScope;

    public NewScanTargetPage(IWorkspace iWorkspace, String string) {
        super(TARGET_TITLE);
        this.setTitle(TARGET_TITLE);
        this.setDescription(TARGET_DESCRIPTION);
        this.workspace = iWorkspace;
        this.targetUriText = string;
    }

    public boolean isTargetValid() {
        return this.isValidScope(this.getScanTargetScope());
    }

    private boolean isValidScope(ITargetScope iTargetScope) {
        return iTargetScope != null && !iTargetScope.isEmpty();
    }

    public ITargetScope getScanTargetScope() {
        if (this.scanTargetUriText.isEnabled()) {
            return this.uriScope;
        }
        return this.comboScope;
    }

    public String getUriTextIfValid() {
        String string = this.scanTargetUriText.getText();
        if (UriTools.isTextValidURI((String)string)) {
            return string;
        }
        return null;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.createTargetGroup(composite2);
        this.createScopeURIGroup(composite2);
        if (this.targetUriText != null && !this.targetUriText.isEmpty()) {
            this.scanTargetUriText.setText(this.targetUriText);
            this.setUriScopeFromText(this.targetUriText);
        }
        this.refreshScopeCombo();
        this.updatePage();
        this.setControl((Control)composite2);
    }

    private void createTargetGroup(Composite composite) {
        Group group = this.createTargetGroupControl(composite);
        this.createBaseURIControls((Composite)group);
        this.createScopeControls((Composite)group);
    }

    private Group createTargetGroupControl(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Scan Target");
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 15;
        gridLayout.marginBottom = 15;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        return group;
    }

    private void createBaseURIControls(Composite composite) {
        final Button button = new Button(composite, 16);
        button.setText("Enter a base URI for scan:");
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.scanTargetUriText = new Text(composite, 2052);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        gridData.widthHint = 300;
        gridData.horizontalIndent = 20;
        this.scanTargetUriText.setLayoutData((Object)gridData);
        this.scanTargetUriText.setMessage("Enter URI to scan");
        this.scanTargetUriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewScanTargetPage.this.setUriScopeFromText(NewScanTargetPage.this.scanTargetUriText.getText());
            }
        });
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewScanTargetPage.this.scanTargetUriText.setEnabled(button.getSelection());
                NewScanTargetPage.this.updatePage();
            }
        });
        button.setSelection(true);
    }

    private void setUriScopeFromText(String string) {
        if (this.uriScope == null) {
            this.uriScope = this.workspace.getTargetScopeManager().createNewScope();
        }
        this.uriScope.clear();
        if (UriTools.isTextValidURI((String)string)) {
            this.uriScope.addScopeURI(UriTools.getURIFromText((String)string));
        }
        this.updatePage();
    }

    private void createScopeControls(Composite composite) {
        final Button button = new Button(composite, 16);
        button.setText("Choose a target scope for scan");
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new RowLayout());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = 20;
        composite2.setLayoutData((Object)gridData);
        this.scopeComboViewer = new ComboViewer(composite2, 8);
        this.scopeComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.scopeComboViewer.getCombo().setEnabled(false);
        this.scopeComboViewer.getCombo().setLayoutData((Object)new RowData(250, -1));
        this.scopeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                if (structuredSelection.getFirstElement() instanceof ITargetScope) {
                    NewScanTargetPage.this.comboScope = (ITargetScope)structuredSelection.getFirstElement();
                    NewScanTargetPage.this.updatePage();
                }
            }
        });
        final Button button2 = new Button(composite2, 0);
        button2.setText("Edit Scopes");
        button2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewScanTargetPage.this.handleEditScopes();
            }
        });
        button2.setEnabled(false);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean bl = button.getSelection();
                NewScanTargetPage.this.scopeComboViewer.getCombo().setEnabled(bl);
                button2.setEnabled(bl);
                NewScanTargetPage.this.updatePage();
            }
        });
    }

    private void handleEditScopes() {
        EditScopeDialog editScopeDialog = new EditScopeDialog(this.getShell());
        editScopeDialog.create();
        editScopeDialog.open();
        this.refreshScopeCombo();
    }

    private void refreshScopeCombo() {
        ITargetScopeManager iTargetScopeManager = this.workspace.getTargetScopeManager();
        this.scopeComboViewer.setInput((Object)iTargetScopeManager.getAllScopes().toArray());
        this.scopeComboViewer.setSelection((ISelection)new StructuredSelection((Object)iTargetScopeManager.getActiveScope()));
    }

    private void createScopeURIGroup(Composite composite) {
        Group group = new Group(composite, 0);
        this.includeModelContent = new Button((Composite)group, 32);
        this.scopeURIViewer = new ListViewer((Composite)group, 2820);
        group.setText("Web Model");
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.includeModelContent.setText("Include previously discovered paths from Web model");
        this.includeModelContent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.includeModelContent.setSelection(true);
        this.scopeURIViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridData gridData = new GridData(4, 4, true, true);
        this.scopeURIViewer.getList().setLayoutData((Object)gridData);
        this.includeModelContent.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewScanTargetPage.this.scopeURIViewer.getList().setEnabled(NewScanTargetPage.this.includeModelContent.getSelection());
            }
        });
    }

    private void updatePage() {
        this.refreshScopeUriList(this.getScanTargetScope());
        this.enableButtonForIncludeModel();
        this.maybeDisplayError();
        this.setPageComplete(this.isTargetValid());
    }

    private void refreshScopeUriList(ITargetScope iTargetScope) {
        if (iTargetScope == null) {
            this.scopeURIViewer.setInput((Object)new Object[0]);
            return;
        }
        InScopeWebVisitor inScopeWebVisitor = new InScopeWebVisitor(iTargetScope);
        this.workspace.getWebModel().accept((IWebModelVisitor)inScopeWebVisitor);
        this.scopeURIViewer.setInput((Object)inScopeWebVisitor.getScopeURIs().toArray());
    }

    private void enableButtonForIncludeModel() {
        this.includeModelContent.setEnabled(this.scopeURIViewer.getList().getItems().length != 0);
    }

    private void maybeDisplayError() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.scanTargetUriText.isEnabled()) {
            this.maybeDisplayErrorForUriText();
        } else {
            this.maybeDisplayErrorForScopeCombo();
        }
    }

    private void maybeDisplayErrorForUriText() {
        String string = this.scanTargetUriText.getText();
        if (string.isEmpty()) {
            this.setMessage("Enter a target URI");
            return;
        }
        if (!UriTools.isTextValidURI((String)this.scanTargetUriText.getText())) {
            this.setErrorMessage("Target URI is invalid.  Enter a properly formatted target URI.");
        }
    }

    private void maybeDisplayErrorForScopeCombo() {
        if (this.comboScope == null) {
            this.setMessage("Select a Target Scope");
        } else if (this.comboScope.isEmpty()) {
            this.setErrorMessage("Selected Target Scope is empty.  Edit scope to add target URIs");
        }
    }
}

